/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests;

import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.resolver.Resolver;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.RuntimeType;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.test.gravia.itests.support.ArchiveBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ResolverServiceTest {
    private Resolver resolver;

    @Deployment
    public static Archive<?> deployment() {
        final ArchiveBuilder archive = new ArchiveBuilder("resolver-service");
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(archive.getName());
                    builder.addBundleVersion("1.0.0");
                    builder.addImportPackages(new Class[]{Runtime.class, Resolver.class});
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(archive.getName(), "1.0.0");
                return builder.openStream();
            }
        });
        return archive.getArchive();
    }

    @Before
    public void setUp() throws Exception {
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        ModuleContext syscontext = runtime.getModuleContext();
        ServiceReference sref = syscontext.getServiceReference(Resolver.class);
        Assert.assertNotNull((String)"Resolver reference not null", (Object)sref);
        this.resolver = (Resolver)syscontext.getService(sref);
    }

    @Test
    public void testResolver() throws Exception {
        Assert.assertNotNull((String)"Resolver not null", (Object)this.resolver);
    }
}

