/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HttpRequest {
    public static String get(String spec, long timeout, TimeUnit unit) throws IOException {
        return HttpRequest.get(spec, null, timeout, unit);
    }

    public static String get(final String spec, final Map<String, String> headers, final long timeout, final TimeUnit unit) throws IOException {
        try {
            Callable<String> task = new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return HttpRequest.processResponse(new URL(spec), headers, timeout, unit);
                }
            };
            return HttpRequest.execute(task, timeout, unit);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IOException("Error accessing: " + spec, ex);
        }
    }

    private static String execute(Callable<String> task, long timeout, TimeUnit unit) throws TimeoutException, ExecutionException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<String> result = executor.submit(task);
        try {
            String string = result.get(timeout, unit);
            return string;
        }
        catch (TimeoutException e) {
            result.cancel(true);
            throw e;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            executor.shutdownNow();
            try {
                executor.awaitTermination(timeout, unit);
            }
            catch (InterruptedException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String processResponse(URL url, Map<String, String> headers, long timeout, TimeUnit unit) throws IOException {
        int responseCode = 0;
        String lastError = "No Error";
        String lastResult = "No Result";
        long now = System.currentTimeMillis();
        long start = System.currentTimeMillis();
        while (responseCode != 200 && now < start + unit.toMillis(timeout)) {
            block20: {
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                if (headers != null) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        con.addRequestProperty(entry.getKey(), entry.getValue());
                    }
                }
                con.setDoInput(true);
                try {
                    responseCode = con.getResponseCode();
                    if (responseCode != 200) {
                        InputStream err = con.getErrorStream();
                        if (err != null) {
                            try {
                                lastError = HttpRequest.read(err);
                                break block20;
                            }
                            finally {
                                err.close();
                            }
                        }
                        try (InputStream in = con.getInputStream();){
                            lastError = HttpRequest.read(in);
                            break block20;
                        }
                    }
                    try (InputStream in = con.getInputStream();){
                        lastResult = HttpRequest.read(in);
                    }
                }
                finally {
                    con.disconnect();
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                lastError = ex.toString();
                break;
            }
            now = System.currentTimeMillis();
        }
        if (responseCode != 200) {
            throw new IOException(lastError);
        }
        return lastResult;
    }

    private static String read(InputStream in) throws IOException {
        int b;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((b = in.read()) != -1) {
            out.write(b);
        }
        return out.toString();
    }
}

