/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests;

import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.osgi.StartLevelAware;
import org.jboss.gravia.runtime.BundleActivatorBridge;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleActivator;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.RuntimeType;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.test.gravia.itests.support.AnnotatedContextListener;
import org.jboss.test.gravia.itests.support.ArchiveBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ModuleLifecycleTest {
    @Deployment
    @StartLevelAware(autostart=true)
    public static Archive<?> deployment() {
        final ArchiveBuilder archive = new ArchiveBuilder("simple-module");
        archive.addClasses(ModuleLifecycleTest.class, Activator.class);
        archive.addClasses(RuntimeType.TOMCAT, AnnotatedContextListener.class);
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                builder.addBundleManifestVersion(2);
                builder.addBundleSymbolicName(archive.getName());
                builder.addBundleVersion("1.0.0");
                builder.addBundleActivator(BundleActivatorBridge.class);
                builder.addManifestHeader("Module-Activator", Activator.class.getName());
                builder.addImportPackages(new Class[]{RuntimeLocator.class});
                return builder.openStream();
            }
        });
        return archive.getArchive();
    }

    @Test
    public void testModuleLifecycle() throws Exception {
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        Module modA = runtime.getModule(this.getClass().getClassLoader());
        Assert.assertEquals((Object)Module.State.ACTIVE, (Object)modA.getState());
        String symbolicName = (String)modA.getHeaders().get("Bundle-SymbolicName");
        Assert.assertEquals((Object)"simple-module", (Object)symbolicName);
        ModuleContext context = modA.getModuleContext();
        Module sysmodule = runtime.getModule(0L);
        symbolicName = (String)sysmodule.getHeaders().get("Bundle-SymbolicName");
        Assert.assertNotNull((String)"System bundle symbolic name not null", (Object)symbolicName);
        ServiceReference sref = context.getServiceReference(String.class);
        String service = (String)context.getService(sref);
        Assert.assertEquals((Object)"Hello", (Object)service);
        modA.stop();
        Assert.assertEquals((Object)Module.State.INSTALLED, (Object)modA.getState());
        modA.uninstall();
        Assert.assertEquals((Object)Module.State.UNINSTALLED, (Object)modA.getState());
        try {
            modA.start();
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
    }

    public static class Activator
    implements ModuleActivator {
        ServiceRegistration<String> sreg;

        public void start(ModuleContext context) throws Exception {
            this.sreg = context.registerService(String.class, (Object)new String("Hello"), null);
        }

        public void stop(ModuleContext context) throws Exception {
            this.sreg.unregister();
        }
    }
}

