/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.gravia.arquillian.container.ContainerSetup;
import org.jboss.gravia.arquillian.container.managed.ManagedSetupTask;
import org.jboss.gravia.itests.support.AnnotatedContextListener;
import org.jboss.gravia.itests.support.ArchiveBuilder;
import org.jboss.gravia.itests.support.HttpRequest;
import org.jboss.gravia.provision.Provisioner;
import org.jboss.gravia.provision.ResourceHandle;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.resolver.Environment;
import org.jboss.gravia.resolver.Resolver;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.IdentityRequirementBuilder;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.gravia.resource.MavenCoordinates;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceBuilder;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.Version;
import org.jboss.gravia.resource.VersionRange;
import org.jboss.gravia.runtime.BundleActivatorBridge;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.RuntimeType;
import org.jboss.gravia.runtime.ServiceLocator;
import org.jboss.gravia.runtime.WebAppContextListener;
import org.jboss.gravia.runtime.Wiring;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.gravia.itests.sub.a.ModuleActivatorA;
import org.jboss.test.gravia.itests.sub.a1.ModuleStateA;
import org.jboss.test.gravia.itests.sub.b.CamelTransformHttpActivator;
import org.jboss.test.gravia.itests.sub.b.ModuleActivatorB;
import org.jboss.test.gravia.itests.sub.b1.ModuleStateB;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.service.http.HttpService;

@RunWith(value=Arquillian.class)
@ContainerSetup(value={Setup.class})
public class ProvisionerServiceTest {
    static final String RESOURCE_A = "resourceA";
    static final String RESOURCE_B = "resourceB";
    static final String RESOURCE_B1 = "resourceB1";
    static final String RESOURCE_C = "resourceC";
    static final String RESOURCE_D = "resourceD";
    static final String RESOURCE_E = "resourceE";
    static final String RESOURCE_F = "resourceF";
    static final String CONTENT_F1 = "contentF1";
    static final String CONTENT_F2 = "contentF2";
    static final String CONTENT_F3 = "contentF3";
    static final String RESOURCE_G = "resourceG";
    static final String CONTENT_G1 = "contentG1";
    static final String CONTENT_G2 = "contentG2";
    static final String CONTENT_G3 = "contentG3";
    @ArquillianResource
    Deployer deployer;

    @Deployment
    public static Archive<?> deployment() {
        final ArchiveBuilder archive = new ArchiveBuilder("provisioner-service");
        archive.addClasses(HttpRequest.class);
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(archive.getName());
                    builder.addBundleVersion("1.0.0");
                    builder.addImportPackages(new Class[]{Runtime.class, Resource.class, Provisioner.class, Resolver.class, Repository.class});
                    builder.addImportPackages(new Class[]{MBeanServer.class});
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(archive.getName(), "1.0.0");
                return builder.openStream();
            }
        });
        return archive.getArchive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProvisionStreamResource() throws Exception {
        Provisioner provisioner = (Provisioner)ServiceLocator.getRequiredService(Provisioner.class);
        ResourceIdentity identityA = ResourceIdentity.fromString((String)RESOURCE_A);
        ResourceBuilder builderA = provisioner.getContentResourceBuilder(identityA, this.deployer.getDeployment(RESOURCE_A));
        ResourceHandle handle = provisioner.installResource(builderA.getResource());
        try {
            Runtime runtime = RuntimeLocator.getRequiredRuntime();
            Module module = runtime.getModule(identityA);
            Assert.assertNotNull((String)"Module not null", (Object)module);
            Assert.assertEquals((String)("ACTIVE " + module), (Object)Module.State.ACTIVE, (Object)module.getState());
            MBeanServer server = (MBeanServer)ServiceLocator.getRequiredService(MBeanServer.class);
            Assert.assertTrue((String)"MBean registered", (boolean)server.isRegistered(this.getObjectName(module)));
            Assert.assertEquals((Object)"ACTIVE", (Object)server.getAttribute(this.getObjectName(module), "ModuleState"));
        }
        finally {
            handle.uninstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedStreamResource() throws Exception {
        ArrayList<ResourceHandle> handles = new ArrayList<ResourceHandle>();
        Provisioner provisioner = (Provisioner)ServiceLocator.getRequiredService(Provisioner.class);
        ResourceIdentity identityB = ResourceIdentity.fromString((String)RESOURCE_B);
        ResourceBuilder builderB = provisioner.getContentResourceBuilder(identityB, this.deployer.getDeployment(RESOURCE_B));
        ResourceIdentity identityB1 = ResourceIdentity.fromString((String)RESOURCE_B1);
        ResourceBuilder builderB1 = provisioner.getContentResourceBuilder(identityB1, this.deployer.getDeployment(RESOURCE_B1));
        handles.add(provisioner.installSharedResource(builderB.getResource()));
        handles.add(provisioner.installResource(builderB1.getResource()));
        try {
            Runtime runtime = RuntimeLocator.getRequiredRuntime();
            for (ResourceHandle handle : handles) {
                ResourceIdentity identity = handle.getResource().getIdentity();
                Assert.assertSame((Object)handle.getModule(), (Object)runtime.getModule(identity));
                Assert.assertEquals((String)("ACTIVE " + identity), (Object)Module.State.ACTIVE, (Object)handle.getModule().getState());
            }
            Module moduleB1 = runtime.getModule(identityB1);
            MBeanServer server = (MBeanServer)ServiceLocator.getRequiredService(MBeanServer.class);
            Assert.assertTrue((String)"MBean registered", (boolean)server.isRegistered(this.getObjectName(moduleB1)));
            Assert.assertEquals((Object)"ACTIVE", (Object)server.getAttribute(this.getObjectName(moduleB1), "ModuleState"));
        }
        finally {
            for (ResourceHandle handle : handles) {
                handle.uninstall();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMavenResource() throws Exception {
        Provisioner provisioner = (Provisioner)ServiceLocator.getRequiredService(Provisioner.class);
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        Assume.assumeFalse((RuntimeType.TOMCAT == RuntimeType.getRuntimeType() ? 1 : 0) != 0);
        ResourceIdentity identityA = ResourceIdentity.fromString((String)"camel.core.unshared");
        MavenCoordinates mavenid = MavenCoordinates.parse((String)"org.apache.camel:camel-core:jar:2.11.0");
        ResourceBuilder builderA = provisioner.getMavenResourceBuilder(identityA, mavenid);
        ResourceHandle handleA = provisioner.installResource(builderA.getResource());
        try {
            Assert.assertSame((Object)handleA.getModule(), (Object)runtime.getModule(identityA));
            Assert.assertEquals((String)("ACTIVE " + identityA), (Object)Module.State.ACTIVE, (Object)handleA.getModule().getState());
        }
        finally {
            handleA.uninstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedMavenResource() throws Exception {
        Provisioner provisioner = (Provisioner)ServiceLocator.getRequiredService(Provisioner.class);
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        ResourceIdentity identityA = ResourceIdentity.fromString((String)"camel.core.shared");
        MavenCoordinates mavenid = MavenCoordinates.parse((String)"org.apache.camel:camel-core:jar:2.11.0");
        ResourceBuilder builderA = provisioner.getMavenResourceBuilder(identityA, mavenid);
        builderA.addIdentityRequirement("javax.api");
        builderA.addIdentityRequirement("org.slf4j");
        ResourceHandle handleA = provisioner.installSharedResource(builderA.getResource());
        try {
            Assert.assertSame((Object)handleA.getModule(), (Object)runtime.getModule(identityA));
            Assert.assertEquals((String)("ACTIVE " + identityA), (Object)Module.State.ACTIVE, (Object)handleA.getModule().getState());
            ResourceIdentity identityC = ResourceIdentity.fromString((String)RESOURCE_C);
            ResourceBuilder builderC = provisioner.getContentResourceBuilder(identityC, this.deployer.getDeployment(RESOURCE_C));
            Map attsC = builderC.getMutableResource().getIdentityCapability().getAttributes();
            attsC.put("runtime.name", "resourceC.war");
            ResourceHandle handleC = provisioner.installResource(builderC.getResource());
            try {
                String reqspec = "/gravia/service?test=Kermit";
                Assert.assertEquals((Object)"Hello Kermit", (Object)this.performCall(reqspec));
            }
            finally {
                handleC.uninstall();
            }
        }
        finally {
            handleA.uninstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbstractFeature() throws Exception {
        Provisioner provisioner = (Provisioner)ServiceLocator.getRequiredService(Provisioner.class);
        ResourceIdentity identity = ResourceIdentity.fromString((String)"camel.core.feature:0.0.0");
        Requirement req = new IdentityRequirementBuilder(identity).getRequirement();
        Set result = provisioner.provisionResources(Collections.singleton(req));
        ArrayList<ResourceHandle> handles = new ArrayList<ResourceHandle>(result);
        try {
            Environment environment = provisioner.getEnvironment();
            Map wirings = environment.getWirings();
            ResourceIdentity residA = ResourceIdentity.create((String)"org.apache.camel.core", (String)"2.11.0");
            Resource resA = environment.getResource(residA);
            Assert.assertNotNull((String)"Resource in environment", (Object)resA);
            Wiring wiringA = (Wiring)wirings.get(resA);
            Assert.assertNotNull((String)"Wiring in environment", (Object)wiringA);
            Assert.assertEquals((String)"Two required wires", (long)2L, (long)wiringA.getRequiredResourceWires(null).size());
            DefaultResourceBuilder builderD = new DefaultResourceBuilder();
            ResourceIdentity residD = ResourceIdentity.create((String)RESOURCE_D, (Version)Version.emptyVersion);
            Map attsD = builderD.addIdentityCapability(residD).getAttributes();
            attsD.put("runtime.name", "resourceD.war");
            builderD.addContentCapability(this.deployer.getDeployment(RESOURCE_D));
            Resource resD = builderD.getResource();
            handles.add(provisioner.installResource(resD));
            Assert.assertTrue((String)"At least one resource", (handles.size() > 0 ? 1 : 0) != 0);
            String reqspec = "/gravia/service?test=Kermit";
            Assert.assertEquals((Object)"Hello Kermit", (Object)this.performCall(reqspec));
            Runtime runtime = RuntimeLocator.getRequiredRuntime();
            Assert.assertNotNull((String)"Module available", (Object)runtime.getModule(residA));
            Assert.assertNotNull((String)"Module available", (Object)runtime.getModule(residD));
            wirings = environment.getWirings();
            resA = environment.getResource(residA);
            Assert.assertNotNull((String)"Resource in environment", (Object)resA);
            wiringA = (Wiring)wirings.get(resA);
            Assert.assertEquals((String)"Two required wires", (long)2L, (long)wiringA.getRequiredResourceWires(null).size());
            resD = environment.getResource(residD);
            Assert.assertNotNull((String)"Resource in environment", (Object)resD);
            Wiring wiringB = (Wiring)wirings.get(resD);
            Assert.assertNull((String)"Wiring not in environment", (Object)wiringB);
        }
        finally {
            for (ResourceHandle handle : handles) {
                handle.uninstall();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRepositoryResourceWithDependency() throws Exception {
        Provisioner provisioner = (Provisioner)ServiceLocator.getRequiredService(Provisioner.class);
        DefaultResourceBuilder builderE = new DefaultResourceBuilder();
        Capability icapE = builderE.addIdentityCapability(RESOURCE_E, Version.emptyVersion);
        icapE.getAttributes().put("runtime.name", "resourceE.war");
        builderE.addContentCapability(this.deployer.getDeployment(RESOURCE_E));
        builderE.addIdentityRequirement("org.apache.camel.core", new VersionRange("[2.11,3.0)"));
        Resource res = builderE.getResource();
        Resource resB = provisioner.getRepository().addResource(res);
        Assert.assertEquals((Object)"resourceE:0.0.0", (Object)resB.getIdentity().toString());
        try {
            Requirement req = new IdentityRequirementBuilder(resB.getIdentity()).getRequirement();
            Set result = provisioner.provisionResources(Collections.singleton(req));
            ArrayList handles = new ArrayList(result);
            try {
                String reqspec = "/gravia/service?test=Kermit";
                Assert.assertEquals((Object)"Hello Kermit", (Object)this.performCall(reqspec));
                Runtime runtime = RuntimeLocator.getRequiredRuntime();
                ResourceIdentity residA = ResourceIdentity.create((String)"org.apache.camel.core", (String)"2.11.0");
                Assert.assertNotNull((String)"Module available", (Object)runtime.getModule(residA));
                ResourceIdentity residB = ResourceIdentity.create((String)RESOURCE_E, (Version)Version.emptyVersion);
                Assert.assertNotNull((String)"Module available", (Object)runtime.getModule(residB));
                Environment environment = provisioner.getEnvironment();
                Map wirings = environment.getWirings();
                Resource resA = environment.getResource(residA);
                Assert.assertNotNull((String)"Resource in environment", (Object)resA);
                Wiring wiringA = (Wiring)wirings.get(resA);
                Assert.assertNotNull((String)"Wiring in environment", (Object)wiringA);
                Assert.assertEquals((String)"Two required wires", (long)2L, (long)wiringA.getRequiredResourceWires(null).size());
                Assert.assertEquals((String)"One provided wires", (long)1L, (long)wiringA.getProvidedResourceWires(null).size());
                resB = environment.getResource(residB);
                Assert.assertNotNull((String)"Resource in environment", (Object)resB);
                Wiring wiringB = (Wiring)wirings.get(resB);
                Assert.assertNotNull((String)"Wiring in environment", (Object)wiringB);
                Assert.assertEquals((String)"One required wires", (long)1L, (long)wiringB.getRequiredResourceWires(null).size());
                Assert.assertEquals((String)"Zero provided wires", (long)0L, (long)wiringB.getProvidedResourceWires(null).size());
            }
            finally {
                for (ResourceHandle handle : handles) {
                    handle.uninstall();
                }
            }
        }
        finally {
            provisioner.getRepository().removeResource(resB.getIdentity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleContentCapabilities() throws Exception {
        Provisioner provisioner = (Provisioner)ServiceLocator.getRequiredService(Provisioner.class);
        DefaultResourceBuilder builderF = new DefaultResourceBuilder();
        ResourceIdentity identityF = ResourceIdentity.create((String)RESOURCE_F, (Version)Version.emptyVersion);
        builderF.addIdentityCapability(identityF);
        builderF.addContentCapability(this.deployer.getDeployment(CONTENT_F1), null, Collections.singletonMap("include.runtime.type", RuntimeType.TOMCAT.name()));
        builderF.addContentCapability(this.deployer.getDeployment(CONTENT_F2), null, Collections.singletonMap("include.runtime.type", RuntimeType.WILDFLY.name()));
        builderF.addContentCapability(this.deployer.getDeployment(CONTENT_F3), null, Collections.singletonMap("include.runtime.type", RuntimeType.KARAF.name()));
        DefaultResourceBuilder builderG = new DefaultResourceBuilder();
        ResourceIdentity identityG = ResourceIdentity.create((String)RESOURCE_G, (Version)Version.emptyVersion);
        builderG.addIdentityCapability(identityG);
        builderG.addContentCapability(this.deployer.getDeployment(CONTENT_G1), null, Collections.singletonMap("include.runtime.type", RuntimeType.TOMCAT.name()));
        builderG.addContentCapability(this.deployer.getDeployment(CONTENT_G2), null, Collections.singletonMap("include.runtime.type", RuntimeType.WILDFLY.name()));
        builderG.addContentCapability(this.deployer.getDeployment(CONTENT_G3), null, Collections.singletonMap("include.runtime.type", RuntimeType.KARAF.name()));
        ArrayList<ResourceHandle> handles = new ArrayList<ResourceHandle>();
        handles.add(provisioner.installSharedResource(builderF.getResource()));
        handles.add(provisioner.installResource(builderG.getResource()));
        try {
            Runtime runtime = RuntimeLocator.getRequiredRuntime();
            for (ResourceHandle handle : handles) {
                ResourceIdentity identity = handle.getResource().getIdentity();
                Assert.assertSame((Object)handle.getModule(), (Object)runtime.getModule(identity));
                Assert.assertEquals((String)("ACTIVE " + identity), (Object)Module.State.ACTIVE, (Object)handle.getModule().getState());
            }
            Module module = runtime.getModule(identityG);
            MBeanServer server = (MBeanServer)ServiceLocator.getRequiredService(MBeanServer.class);
            Assert.assertTrue((String)"MBean registered", (boolean)server.isRegistered(this.getObjectName(module)));
            Assert.assertEquals((Object)"ACTIVE", (Object)server.getAttribute(this.getObjectName(module), "ModuleState"));
        }
        finally {
            for (ResourceHandle handle : handles) {
                handle.uninstall();
            }
        }
    }

    private String performCall(String path) throws Exception {
        return this.performCall(path, null, 2L, TimeUnit.SECONDS);
    }

    private String performCall(String path, Map<String, String> headers, long timeout, TimeUnit unit) throws Exception {
        return HttpRequest.get("http://localhost:8080" + path, headers, timeout, unit);
    }

    private ObjectName getObjectName(Module module) throws MalformedObjectNameException {
        ResourceIdentity identity = module.getIdentity();
        return new ObjectName("test:name=" + identity.getSymbolicName() + ",version=" + identity.getVersion());
    }

    @Deployment(name="resourceA", managed=false, testable=false)
    public static Archive<?> getResourceA() {
        ArchiveBuilder archive = new ArchiveBuilder(RESOURCE_A);
        archive.addClasses(RuntimeType.TOMCAT, AnnotatedContextListener.class, WebAppContextListener.class);
        archive.addClasses(RuntimeType.KARAF, BundleActivatorBridge.class);
        archive.addClasses(ModuleActivatorA.class, ModuleStateA.class);
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(ProvisionerServiceTest.RESOURCE_A);
                    builder.addBundleActivator(BundleActivatorBridge.class);
                    builder.addManifestHeader("Module-Activator", ModuleActivatorA.class.getName());
                    builder.addImportPackages(new Class[]{Runtime.class, Resource.class, ServiceLocator.class, MBeanServer.class});
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(ProvisionerServiceTest.RESOURCE_A, Version.emptyVersion);
                builder.addManifestHeader("Module-Activator", ModuleActivatorA.class.getName());
                builder.addManifestHeader("Dependencies", "org.jboss.gravia");
                return builder.openStream();
            }
        });
        return archive.getArchive();
    }

    @Deployment(name="resourceB", managed=false, testable=false)
    public static Archive<?> getResourceB() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"resourceB.jar");
        archive.addClasses(new Class[]{ModuleStateB.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                builder.addBundleManifestVersion(2);
                builder.addBundleSymbolicName(ProvisionerServiceTest.RESOURCE_B);
                builder.addExportPackages(new Class[]{ModuleStateB.class});
                builder.addImportPackages(new Class[]{Runtime.class, Resource.class});
                return builder.openStream();
            }
        });
        return archive;
    }

    @Deployment(name="resourceB1", managed=false, testable=false)
    public static Archive<?> getResourceB1() {
        ArchiveBuilder archive = new ArchiveBuilder(RESOURCE_B1);
        archive.addClasses(RuntimeType.TOMCAT, AnnotatedContextListener.class, WebAppContextListener.class);
        archive.addClasses(RuntimeType.KARAF, BundleActivatorBridge.class);
        archive.addClasses(ModuleActivatorB.class);
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(ProvisionerServiceTest.RESOURCE_B1);
                    builder.addBundleActivator(BundleActivatorBridge.class);
                    builder.addManifestHeader("Module-Activator", ModuleActivatorB.class.getName());
                    builder.addImportPackages(new Class[]{Runtime.class, Resource.class, ServiceLocator.class});
                    builder.addImportPackages(new Class[]{MBeanServer.class, ModuleStateB.class});
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(ProvisionerServiceTest.RESOURCE_B1, Version.emptyVersion);
                builder.addManifestHeader("Module-Activator", ModuleActivatorB.class.getName());
                builder.addManifestHeader("Dependencies", "org.jboss.gravia,resourceB");
                return builder.openStream();
            }
        });
        return archive.getArchive();
    }

    @Deployment(name="resourceC", managed=false, testable=false)
    public static Archive<?> getResourceC() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"resourceC.war");
        archive.addClasses(new Class[]{AnnotatedContextListener.class, WebAppContextListener.class});
        archive.addClasses(new Class[]{CamelTransformHttpActivator.class, BundleActivatorBridge.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(ProvisionerServiceTest.RESOURCE_C);
                    builder.addBundleActivator(BundleActivatorBridge.class);
                    builder.addManifestHeader("Module-Activator", CamelTransformHttpActivator.class.getName());
                    builder.addImportPackages(new Class[]{BundleActivatorBridge.class, Runtime.class, Servlet.class, HttpServlet.class, HttpService.class});
                    builder.addImportPackages(new Class[]{CamelContext.class, DefaultCamelContext.class, RouteBuilder.class, RouteDefinition.class});
                    builder.addBundleClasspath("WEB-INF/classes");
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(ProvisionerServiceTest.RESOURCE_C, Version.emptyVersion);
                builder.addManifestHeader("Module-Activator", CamelTransformHttpActivator.class.getName());
                builder.addManifestHeader("Dependencies", "camel.core.shared");
                return builder.openStream();
            }
        });
        return archive;
    }

    @Deployment(name="resourceD", managed=false, testable=false)
    public static Archive<?> getResourceD() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"resourceD.war");
        archive.addClasses(new Class[]{AnnotatedContextListener.class, WebAppContextListener.class});
        archive.addClasses(new Class[]{CamelTransformHttpActivator.class, BundleActivatorBridge.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(ProvisionerServiceTest.RESOURCE_D);
                    builder.addBundleActivator(BundleActivatorBridge.class);
                    builder.addManifestHeader("Module-Activator", CamelTransformHttpActivator.class.getName());
                    builder.addImportPackages(new Class[]{BundleActivatorBridge.class, Runtime.class, Servlet.class, HttpServlet.class, HttpService.class});
                    builder.addImportPackages(new Class[]{CamelContext.class, DefaultCamelContext.class, RouteBuilder.class, RouteDefinition.class});
                    builder.addBundleClasspath("WEB-INF/classes");
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(ProvisionerServiceTest.RESOURCE_D, Version.emptyVersion);
                builder.addManifestHeader("Module-Activator", CamelTransformHttpActivator.class.getName());
                builder.addManifestHeader("Dependencies", "org.apache.camel.core");
                return builder.openStream();
            }
        });
        return archive;
    }

    @Deployment(name="resourceE", managed=false, testable=false)
    public static Archive<?> getResourceE() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"resourceE.war");
        archive.addClasses(new Class[]{AnnotatedContextListener.class, WebAppContextListener.class});
        archive.addClasses(new Class[]{CamelTransformHttpActivator.class, BundleActivatorBridge.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(ProvisionerServiceTest.RESOURCE_E);
                    builder.addBundleActivator(BundleActivatorBridge.class);
                    builder.addManifestHeader("Module-Activator", CamelTransformHttpActivator.class.getName());
                    builder.addImportPackages(new Class[]{BundleActivatorBridge.class, Runtime.class, Servlet.class, HttpServlet.class, HttpService.class});
                    builder.addImportPackages(new Class[]{CamelContext.class, DefaultCamelContext.class, RouteBuilder.class, RouteDefinition.class});
                    builder.addBundleClasspath("WEB-INF/classes");
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(ProvisionerServiceTest.RESOURCE_E, Version.emptyVersion);
                builder.addManifestHeader("Module-Activator", CamelTransformHttpActivator.class.getName());
                return builder.openStream();
            }
        });
        return archive;
    }

    @Deployment(name="contentF1", managed=false, testable=false)
    public static Archive<?> getContentF1() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"contentF1.jar");
        archive.addClasses(new Class[]{ModuleStateB.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(ProvisionerServiceTest.RESOURCE_F, Version.emptyVersion);
                return builder.openStream();
            }
        });
        return archive;
    }

    @Deployment(name="contentF2", managed=false, testable=false)
    public static Archive<?> getContentF2() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"contentF2.jar");
        archive.addClasses(new Class[]{ModuleStateB.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(ProvisionerServiceTest.RESOURCE_F, Version.emptyVersion);
                builder.addManifestHeader("Dependencies", "org.jboss.gravia");
                return builder.openStream();
            }
        });
        return archive;
    }

    @Deployment(name="contentF3", managed=false, testable=false)
    public static Archive<?> getContentF3() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"contentF3.jar");
        archive.addClasses(new Class[]{ModuleStateB.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                builder.addBundleManifestVersion(2);
                builder.addBundleSymbolicName(ProvisionerServiceTest.RESOURCE_F);
                builder.addExportPackages(new Class[]{ModuleStateB.class});
                builder.addImportPackages(new Class[]{Runtime.class, Resource.class});
                return builder.openStream();
            }
        });
        return archive;
    }

    @Deployment(name="contentG1", managed=false, testable=false)
    public static Archive<?> getContentG1() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"contentG1.war");
        archive.addClasses(new Class[]{AnnotatedContextListener.class, WebAppContextListener.class});
        archive.addClasses(new Class[]{ModuleActivatorB.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(ProvisionerServiceTest.RESOURCE_G, Version.emptyVersion);
                builder.addManifestHeader("Module-Activator", ModuleActivatorB.class.getName());
                return builder.openStream();
            }
        });
        return archive;
    }

    @Deployment(name="contentG2", managed=false, testable=false)
    public static Archive<?> getContentG2() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"contentG2.jar");
        archive.addClasses(new Class[]{ModuleActivatorB.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(ProvisionerServiceTest.RESOURCE_G, Version.emptyVersion);
                builder.addManifestHeader("Module-Activator", ModuleActivatorB.class.getName());
                builder.addManifestHeader("Dependencies", "org.jboss.gravia,resourceF");
                return builder.openStream();
            }
        });
        return archive;
    }

    @Deployment(name="contentG3", managed=false, testable=false)
    public static Archive<?> getContentG3() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"contentG3.jar");
        archive.addClasses(new Class[]{BundleActivatorBridge.class, ModuleActivatorB.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                builder.addBundleManifestVersion(2);
                builder.addBundleSymbolicName(ProvisionerServiceTest.RESOURCE_G);
                builder.addBundleActivator(BundleActivatorBridge.class);
                builder.addManifestHeader("Module-Activator", ModuleActivatorB.class.getName());
                builder.addImportPackages(new Class[]{Runtime.class, Resource.class, ServiceLocator.class});
                builder.addImportPackages(new Class[]{MBeanServer.class, ModuleStateB.class});
                return builder.openStream();
            }
        });
        return archive;
    }

    public static class Setup
    extends ManagedSetupTask {
        Set<ResourceIdentity> identities;

        protected void beforeDeploy(ManagedSetupTask.ManagedContext context) throws Exception {
            String resname = "META-INF/repository-content/camel.core.feature.xml";
            URL resurl = ((Object)((Object)this)).getClass().getClassLoader().getResource(resname);
            this.identities = this.addRepositoryContent(context, resurl);
        }

        protected void beforeStop(ManagedSetupTask.ManagedContext context) throws Exception {
            this.removeRepositoryContent(context, this.identities);
        }
    }
}

