/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests.sub.b;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.gravia.runtime.ModuleActivator;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ServiceEvent;
import org.jboss.gravia.runtime.ServiceListener;
import org.jboss.gravia.runtime.ServiceReference;
import org.osgi.service.http.HttpService;

public class CamelTransformActivator
implements ModuleActivator {
    private HttpService httpService;
    private CamelContext camelctx;

    public void start(final ModuleContext context) throws Exception {
        this.camelctx = new DefaultCamelContext();
        this.camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").transform((Expression)this.body().prepend((Object)"Hello "));
            }
        });
        this.camelctx.start();
        ServiceReference sref = context.getServiceReference(HttpService.class);
        if (sref != null) {
            this.registerHttpService(context, sref);
        } else {
            ServiceListener listener = new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    ServiceReference sref;
                    String[] classes;
                    if (1 == event.getType() && Arrays.asList(classes = (String[])(sref = event.getServiceReference()).getProperty("objectClass")).contains(HttpService.class.getName())) {
                        CamelTransformActivator.this.registerHttpService(context, sref);
                    }
                }
            };
            context.addServiceListener(listener);
        }
    }

    public void stop(ModuleContext context) throws Exception {
        this.camelctx.stop();
        if (this.httpService != null) {
            this.httpService.unregister("/service");
        }
    }

    private void registerHttpService(ModuleContext context, ServiceReference<?> sref) {
        try {
            this.httpService = (HttpService)context.getService(sref);
            this.httpService.registerServlet("/service", (Servlet)new HttpServiceServlet(this.camelctx), null, null);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot register HttpService", ex);
        }
    }

    static final class HttpServiceServlet
    extends HttpServlet {
        private final CamelContext camelctx;

        HttpServiceServlet(CamelContext camelctx) {
            this.camelctx = camelctx;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
            PrintWriter out = res.getWriter();
            String msg = req.getParameter("test");
            ProducerTemplate producer = this.camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)msg, String.class);
            out.print(result);
            out.close();
        }
    }
}

