/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests.sub.b;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.gravia.runtime.ModuleActivator;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.ServiceTracker;
import org.osgi.service.http.HttpService;

public class CamelTransformActivator
implements ModuleActivator {
    private ServiceTracker<HttpService, HttpService> tracker;
    private HttpService httpService;
    private CamelContext camelctx;

    public void start(ModuleContext context) throws Exception {
        this.camelctx = new DefaultCamelContext();
        this.camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").transform((Expression)this.body().prepend((Object)"Hello "));
            }
        });
        this.camelctx.start();
        this.tracker = new ServiceTracker<HttpService, HttpService>(context, HttpService.class, null){

            public HttpService addingService(ServiceReference<HttpService> sref) {
                CamelTransformActivator.this.httpService = (HttpService)super.addingService(sref);
                CamelTransformActivator.this.registerHttpServiceServlet();
                return CamelTransformActivator.this.httpService;
            }
        };
        this.tracker.open();
    }

    public void stop(ModuleContext context) throws Exception {
        this.camelctx.stop();
        if (this.tracker != null) {
            this.tracker.close();
        }
        if (this.httpService != null) {
            this.httpService.unregister("/service");
        }
    }

    private void registerHttpServiceServlet() {
        try {
            this.httpService.registerServlet("/service", (Servlet)new HttpServiceServlet(this.camelctx), null, null);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot register HttpServiceServlet", ex);
        }
    }

    static final class HttpServiceServlet
    extends HttpServlet {
        private final CamelContext camelctx;

        HttpServiceServlet(CamelContext camelctx) {
            this.camelctx = camelctx;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
            PrintWriter out = res.getWriter();
            String msg = req.getParameter("test");
            ProducerTemplate producer = this.camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)msg, String.class);
            out.print(result);
            out.close();
        }
    }
}

