/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests;

import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.osgi.StartLevelAware;
import org.jboss.gravia.itests.support.AnnotatedContextListener;
import org.jboss.gravia.itests.support.ArchiveBuilder;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.RuntimeType;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.test.gravia.itests.sub.d.ServiceD;
import org.jboss.test.gravia.itests.sub.d1.ServiceD1;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;

@RunWith(value=Arquillian.class)
public class ConfigurationAdminTest {
    @Deployment
    @StartLevelAware(autostart=true)
    public static Archive<?> deployment() {
        final ArchiveBuilder archive = new ArchiveBuilder("configadmin-test");
        archive.addClasses(ConfigurationAdminTest.class);
        archive.addClasses(RuntimeType.TOMCAT, AnnotatedContextListener.class);
        archive.addClasses(ServiceD.class, ServiceD1.class);
        archive.addAsResource("OSGI-INF/org.jboss.test.gravia.itests.sub.d.ServiceD.xml");
        archive.addAsResource("OSGI-INF/org.jboss.test.gravia.itests.sub.d1.ServiceD1.xml");
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(archive.getName());
                    builder.addBundleVersion("1.0.0");
                    builder.addImportPackages(new Class[]{RuntimeLocator.class, ComponentContext.class, ConfigurationAdmin.class, Resource.class});
                    builder.addManifestHeader("Service-Component", "OSGI-INF/org.jboss.test.gravia.itests.sub.d.ServiceD.xml,OSGI-INF/org.jboss.test.gravia.itests.sub.d1.ServiceD1.xml");
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(archive.getName(), "1.0.0");
                builder.addManifestHeader("Service-Component", "OSGI-INF/org.jboss.test.gravia.itests.sub.d.ServiceD.xml,OSGI-INF/org.jboss.test.gravia.itests.sub.d1.ServiceD1.xml");
                return builder.openStream();
            }
        });
        return archive.getArchive();
    }

    @Test
    public void testBasicModule() throws Exception {
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        Module module = runtime.getModule(this.getClass().getClassLoader());
        ModuleContext ctxA = module.getModuleContext();
        ServiceReference srefD = ctxA.getServiceReference(ServiceD.class);
        Assert.assertNotNull((String)"ServiceReference not null", (Object)srefD);
        ServiceD srvD = (ServiceD)ctxA.getService(srefD);
        Assert.assertEquals((Object)"ServiceD#1:ServiceD1#1:null:Hello", (Object)srvD.doStuff("Hello"));
        ConfigurationAdmin configAdmin = this.getConfigurationAdmin(module);
        Configuration config = configAdmin.getConfiguration(ServiceD1.class.getName());
        Assert.assertNotNull((String)"Config not null", (Object)config);
        Assert.assertNull((String)("Config is empty, but was: " + config.getProperties()), (Object)config.getProperties());
        Hashtable<String, String> configProps = new Hashtable<String, String>();
        ((Dictionary)configProps).put("foo", "bar");
        config.update(configProps);
        ServiceD1 srvD1 = srvD.getServiceD1();
        Assert.assertTrue((boolean)srvD1.awaitModified(4000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)"ServiceD#1:ServiceD1#1:bar:Hello", (Object)srvD.doStuff("Hello"));
    }

    protected ConfigurationAdmin getConfigurationAdmin(Module module) {
        ModuleContext context = module.getModuleContext();
        return (ConfigurationAdmin)context.getService(context.getServiceReference(ConfigurationAdmin.class));
    }
}

