/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Dictionary;
import java.util.Hashtable;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.osgi.StartLevelAware;
import org.jboss.gravia.itests.support.AnnotatedContextListener;
import org.jboss.gravia.itests.support.ArchiveBuilder;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.RuntimeType;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.utils.IOUtils;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class URLStreamHandlerTest {
    @Deployment
    @StartLevelAware(autostart=true)
    public static Archive<?> deployment() {
        final ArchiveBuilder archive = new ArchiveBuilder("url-handler-test");
        archive.addClasses(RuntimeType.TOMCAT, AnnotatedContextListener.class);
        archive.addClasses(URLStreamHandlerTest.class);
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(archive.getName());
                    builder.addBundleVersion("1.0.0");
                    builder.addImportPackages(new Class[]{RuntimeLocator.class, IOUtils.class});
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(archive.getName(), "1.0.0");
                return builder.openStream();
            }
        });
        return archive.getArchive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testURLHandlerService() throws Exception {
        try {
            new URL("foo://hi");
            Assert.fail((String)"No handler registered. Should throw a MalformedURLException.");
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        ModuleContext syscontext = runtime.getModuleContext();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("url.handler.protocol", "foo");
        ServiceRegistration sreg = syscontext.registerService(URLStreamHandler.class, (Object)new MyHandler(), props);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copyStream((InputStream)new URL("foo://somehost").openStream(), (OutputStream)baos);
            Assert.assertEquals((Object)"somehost", (Object)new String(baos.toByteArray()));
        }
        finally {
            sreg.unregister();
        }
        try {
            new URL("foo://hi").openConnection();
            Assert.fail((String)"No handler registered any more.");
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    private static class MyHandler
    extends URLStreamHandler {
        private MyHandler() {
        }

        @Override
        public URLConnection openConnection(URL url) throws IOException {
            return new URLConnection(url){

                @Override
                public void connect() throws IOException {
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(this.url.getHost().getBytes());
                }
            };
        }
    }
}

