/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.osgi.StartLevelAware;
import org.jboss.gravia.itests.support.ArchiveBuilder;
import org.jboss.gravia.itests.support.HttpRequest;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.RuntimeType;
import org.jboss.gravia.runtime.ServiceLocator;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.service.http.HttpService;

@RunWith(value=Arquillian.class)
public class HttpServiceTest {
    @Deployment
    @StartLevelAware(autostart=true)
    public static Archive<?> deployment() {
        final RuntimeType targetContainer = ArchiveBuilder.getTargetContainer();
        ArchiveBuilder archive = new ArchiveBuilder("http-service");
        archive.addClasses(HttpRequest.class);
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (targetContainer == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName("http-service");
                    builder.addBundleVersion("1.0.0");
                    builder.addImportPackages(new Class[]{RuntimeLocator.class, Servlet.class, HttpServlet.class, HttpService.class});
                    builder.addBundleClasspath("WEB-INF/classes");
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability("http-service", "1.0.0");
                return builder.openStream();
            }
        });
        return archive.getArchive();
    }

    @Test
    public void testHttpServiceClassLoading() throws Exception {
        Assume.assumeTrue((RuntimeType.getRuntimeType() == RuntimeType.WILDFLY ? 1 : 0) != 0);
        ClassLoader classLoader = RuntimeType.class.getClassLoader();
        Assert.assertTrue((String)("Unexpected: " + classLoader), (boolean)classLoader.toString().contains("org.jboss.gravia"));
        Class<?> serviceClass = classLoader.loadClass(HttpService.class.getName());
        String loaderName = serviceClass.getClassLoader().toString();
        Assert.assertTrue((String)("Unexpected: " + loaderName), (boolean)loaderName.contains("org.osgi.enterprise"));
    }

    @Test
    public void testSystemService() throws Exception {
        Assume.assumeTrue((RuntimeType.getRuntimeType() != RuntimeType.KARAF ? 1 : 0) != 0);
        Assert.assertEquals((Object)"gravia-system", (Object)this.performCall("/gravia/system"));
    }

    @Test
    public void testServletThroughSystemContext() throws Exception {
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        Module module = runtime.getModule(this.getClass().getClassLoader());
        HttpService httpService = (HttpService)ServiceLocator.getRequiredService(HttpService.class);
        String reqspec = "/gravia/servlet?test=module";
        this.assertNotAvailable(reqspec);
        String servletAlias = this.getRuntimeAwareAlias("/servlet");
        httpService.registerServlet(servletAlias, (Servlet)new HttpServiceServlet(module), null, null);
        Assert.assertEquals((Object)"http-service:1.0.0", (Object)this.performCall(reqspec));
        httpService.unregister(servletAlias);
        this.assertNotAvailable(reqspec);
        this.assertNotAvailable(reqspec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServletThroughModuleContext() throws Exception {
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        Module module = runtime.getModule(this.getClass().getClassLoader());
        ModuleContext context = module.getModuleContext();
        ServiceReference sref = context.getServiceReference(HttpService.class);
        HttpService httpService = (HttpService)context.getService(sref);
        String reqspec = "/gravia/servlet?test=module";
        try {
            this.assertNotAvailable(reqspec);
            String servletAlias = this.getRuntimeAwareAlias("/servlet");
            httpService.registerServlet(servletAlias, (Servlet)new HttpServiceServlet(module), null, null);
            Assert.assertEquals((Object)"http-service:1.0.0", (Object)this.performCall(reqspec));
            httpService.unregister(servletAlias);
            this.assertNotAvailable(reqspec);
            this.assertNotAvailable(reqspec);
        }
        finally {
            context.ungetService(sref);
        }
    }

    private void assertNotAvailable(String reqspec) throws Exception {
        try {
            this.performCall(reqspec, null, 500L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getRuntimeAwareAlias(String alias) {
        String context = RuntimeType.getRuntimeType() == RuntimeType.KARAF ? "/gravia" : "";
        return context + alias;
    }

    private String performCall(String path) throws Exception {
        return this.performCall(path, null, 2L, TimeUnit.SECONDS);
    }

    private String performCall(String path, Map<String, String> headers, long timeout, TimeUnit unit) throws Exception {
        Object port = RuntimeLocator.getRequiredRuntime().getProperty("org.osgi.service.http.port", (Object)"8080");
        return HttpRequest.get("http://localhost:" + port + path, headers, timeout, unit);
    }

    static final class HttpServiceServlet
    extends HttpServlet {
        private final Module module;

        HttpServiceServlet(Module module) {
            this.module = module;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
            PrintWriter out = res.getWriter();
            String type = req.getParameter("test");
            if ("param".equals(type)) {
                String value = req.getParameter("param");
                out.print("Hello: " + value);
            } else if ("init".equals(type)) {
                String key = req.getParameter("init");
                String value = this.getInitParameter(key);
                out.print(key + "=" + value);
            } else if ("module".equals(type)) {
                out.print(this.module.getIdentity());
            } else {
                throw new IllegalArgumentException("Invalid 'test' parameter: " + type);
            }
            out.close();
        }
    }
}

