/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.itests.support;

import org.jboss.gravia.runtime.RuntimeType;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.container.WebContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class ArchiveBuilder {
    private final String name;
    private final Archive<?> archive;

    public ArchiveBuilder(String name) {
        this.name = name;
        this.archive = (Archive)ShrinkWrap.create(JavaArchive.class, (String)(name + ".jar"));
    }

    public String getName() {
        return this.name;
    }

    public static RuntimeType getTargetContainer() {
        return RuntimeType.getRuntimeType((String)System.getProperty("target.container"));
    }

    public ArchiveBuilder addClasses(Class<?> ... classes) {
        ClassContainer container = (ClassContainer)this.archive;
        container.addClasses((Class[])classes);
        return this;
    }

    public ArchiveBuilder addPackage(Package pack) {
        ClassContainer container = (ClassContainer)this.archive;
        container.addPackage(pack);
        return this;
    }

    public ArchiveBuilder addClasses(RuntimeType target, Class<?> ... classes) {
        if (ArchiveBuilder.getTargetContainer() == target) {
            ClassContainer container = (ClassContainer)this.archive;
            container.addClasses((Class[])classes);
        }
        return this;
    }

    public ArchiveBuilder addPackage(RuntimeType target, Package pack) {
        if (ArchiveBuilder.getTargetContainer() == target) {
            ClassContainer container = (ClassContainer)this.archive;
            container.addPackage(pack);
        }
        return this;
    }

    public ArchiveBuilder addAsResource(String resname) {
        if (this.archive instanceof WebContainer) {
            WebContainer container = (WebContainer)this.archive;
            container.addAsWebResource(resname, resname);
        } else {
            ResourceContainer container = (ResourceContainer)this.archive;
            container.addAsResource(resname);
        }
        return this;
    }

    public ArchiveBuilder addAsResource(Asset asset, String resname) {
        if (this.archive instanceof WebContainer) {
            WebContainer container = (WebContainer)this.archive;
            ((ResourceContainer)container).addAsResource(asset, resname);
        } else {
            ResourceContainer container = (ResourceContainer)this.archive;
            container.addAsResource(asset, resname);
        }
        return this;
    }

    public ArchiveBuilder setManifest(Asset manifestAsset) {
        ManifestContainer container = (ManifestContainer)this.archive;
        container.setManifest(manifestAsset);
        return this;
    }

    public Archive<?> getArchive() {
        return this.archive;
    }
}

