/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.provision.spi;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.gravia.provision.ProvisionException;
import org.jboss.gravia.provision.ResourceHandle;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.provision.spi.RuntimeEnvironment;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.runtime.spi.ResourceAssociation;

public abstract class AbstractResourceInstaller
implements ResourceInstaller {
    public abstract RuntimeEnvironment getEnvironment();

    @Override
    public synchronized Set<ResourceHandle> installResources(List<Resource> resources, Map<Requirement, Resource> mapping) throws ProvisionException {
        HashSet<ResourceHandle> handles = new HashSet<ResourceHandle>();
        for (Resource res : resources) {
            ResourceIdentity identity = res.getIdentity();
            if (this.isAbstract(res) || this.getEnvironment().getResource(identity) != null) continue;
            handles.add(this.installResourceInternal(res, mapping));
        }
        return Collections.unmodifiableSet(handles);
    }

    @Override
    public synchronized ResourceHandle installResource(Resource res, Map<Requirement, Resource> mapping) throws ProvisionException {
        return this.installResourceInternal(res, mapping);
    }

    private synchronized ResourceHandle installResourceInternal(Resource resource, Map<Requirement, Resource> mapping) throws ProvisionException {
        ResourceAssociation.putResource((Resource)resource);
        try {
            if (this.isShared(resource)) {
                ResourceHandle resourceHandle = this.installSharedResource(resource, mapping);
                return resourceHandle;
            }
            ResourceHandle resourceHandle = this.installUnsharedResource(resource, mapping);
            return resourceHandle;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (ProvisionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ProvisionException("Cannot provision resource: " + resource, ex);
        }
        finally {
            ResourceAssociation.removeResource((ResourceIdentity)resource.getIdentity());
        }
    }

    public abstract ResourceHandle installSharedResource(Resource var1, Map<Requirement, Resource> var2) throws Exception;

    public abstract ResourceHandle installUnsharedResource(Resource var1, Map<Requirement, Resource> var2) throws Exception;

    private boolean isAbstract(Resource res) {
        Object attval = res.getIdentityCapability().getAttribute("type");
        return "abstract".equals(attval);
    }

    private boolean isShared(Resource resource) {
        Object attval = resource.getIdentityCapability().getAttribute("shared");
        return Boolean.parseBoolean((String)attval);
    }
}

