/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.repository.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.gravia.repository.MavenCoordinates;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.repository.RepositoryReader;
import org.jboss.gravia.repository.RepositoryStorage;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.utils.NotNullException;

public abstract class AbstractRepository
implements Repository {
    private final PropertiesProvider propertiesProvider;
    private RepositoryStorage storage;
    private Repository fallback;

    public AbstractRepository(PropertiesProvider propertyProvider) {
        this.propertiesProvider = propertyProvider;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public PropertiesProvider getPropertiesProvider() {
        return this.propertiesProvider;
    }

    public RepositoryStorage getRepositoryStorage() {
        return this.storage;
    }

    public void setRepositoryStorage(RepositoryStorage storage) {
        NotNullException.assertValue((Object)storage, (String)"storage");
        if (this.storage != null) {
            throw new IllegalStateException("RepositoryStorage already set");
        }
        this.storage = storage;
    }

    @Override
    public Repository getFallbackRepository() {
        return this.fallback;
    }

    public void setFallbackRepository(Repository fallback) {
        NotNullException.assertValue((Object)fallback, (String)"fallback");
        if (this.fallback != null) {
            throw new IllegalStateException("Fallback repository already set");
        }
        this.fallback = fallback;
    }

    public RepositoryReader getRepositoryReader() {
        return this.getRequiredRepositoryStorage().getRepositoryReader();
    }

    public <T> T adapt(Class<T> type) {
        Object result = null;
        if (type.isAssignableFrom(this.getClass())) {
            result = this;
        } else if (RepositoryStorage.class.isAssignableFrom(type)) {
            result = this.getRepositoryStorage();
        } else if (RepositoryReader.class.isAssignableFrom(type)) {
            result = this.getRepositoryReader();
        } else if (this.fallback != null) {
            result = this.fallback.adapt(type);
        }
        return (T)result;
    }

    @Override
    public Resource addResource(Resource res) {
        return this.getRequiredRepositoryStorage().addResource(res);
    }

    @Override
    public Resource addResource(Resource res, MavenCoordinates mavenid) {
        Capability icap = res.getIdentityCapability();
        String attkey = "maven.identity";
        String attval = (String)icap.getAttributes().get(attkey);
        if (attval != null && !attval.equals(mavenid.toExternalForm())) {
            throw new IllegalArgumentException("Resource already contains a " + attkey + " attribute: " + attval);
        }
        DefaultResourceBuilder builder = new DefaultResourceBuilder();
        for (Capability aux : res.getCapabilities(null)) {
            Capability cap = builder.addCapability(aux.getNamespace(), aux.getAttributes(), aux.getDirectives());
            if (!"gravia.identity".equals(cap.getNamespace())) continue;
            cap.getAttributes().put(attkey, mavenid.toExternalForm());
        }
        for (Capability aux : res.getRequirements(null)) {
            builder.addRequirement(aux.getNamespace(), aux.getAttributes(), aux.getDirectives());
        }
        Resource rescopy = builder.getResource();
        return this.getRequiredRepositoryStorage().addResource(rescopy);
    }

    @Override
    public Resource removeResource(ResourceIdentity identity) {
        return this.getRequiredRepositoryStorage().removeResource(identity);
    }

    @Override
    public Resource getResource(ResourceIdentity identity) {
        return this.getRequiredRepositoryStorage().getResource(identity);
    }

    @Override
    public Map<Requirement, Collection<Capability>> findProviders(Collection<Requirement> reqs) {
        NotNullException.assertValue(reqs, (String)"reqs");
        HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>();
        for (Requirement req : reqs) {
            Collection<Capability> providers = this.findProviders(req);
            result.put(req, providers);
        }
        return result;
    }

    @Override
    public Collection<Capability> findProviders(Requirement req) {
        NotNullException.assertValue((Object)req, (String)"req");
        RepositoryStorage repositoryStorage = this.getRequiredRepositoryStorage();
        HashSet<Capability> providers = repositoryStorage.findProviders(req);
        if (providers.isEmpty() && this.getFallbackRepository() != null) {
            providers = new HashSet<Capability>();
            for (Capability cap : this.getFallbackRepository().findProviders(req)) {
                Resource res = cap.getResource();
                ResourceIdentity resid = res.getIdentity();
                Resource storageResource = repositoryStorage.getResource(resid);
                if (storageResource == null) {
                    storageResource = repositoryStorage.addResource(res);
                    for (Capability aux : storageResource.getCapabilities(req.getNamespace())) {
                        if (!cap.getAttributes().equals(aux.getAttributes())) continue;
                        cap = aux;
                        break;
                    }
                }
                providers.add(cap);
            }
        }
        return Collections.unmodifiableCollection(providers);
    }

    private RepositoryStorage getRequiredRepositoryStorage() {
        if (this.storage == null) {
            throw new IllegalStateException("RepositoryStorage not set");
        }
        return this.storage;
    }
}

