/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.repository.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.repository.RepositoryReader;
import org.jboss.gravia.repository.RepositoryStorage;
import org.jboss.gravia.resource.DefaultMatchPolicy;
import org.jboss.gravia.resource.DefaultResourceStore;
import org.jboss.gravia.resource.MatchPolicy;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.runtime.spi.PropertiesProvider;

public class MemoryRepositoryStorage
extends DefaultResourceStore
implements RepositoryStorage {
    private final AtomicLong increment = new AtomicLong();
    private final Repository repository;

    public MemoryRepositoryStorage(PropertiesProvider propertyProvider, Repository repository) {
        super(MemoryRepositoryStorage.class.getSimpleName(), (MatchPolicy)new DefaultMatchPolicy());
        this.repository = repository;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public RepositoryReader getRepositoryReader() {
        final Iterator itres = this.getResources();
        return new RepositoryReader(){

            @Override
            public Map<String, String> getRepositoryAttributes() {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("name", MemoryRepositoryStorage.this.getRepository().getName());
                attributes.put("increment", new Long(MemoryRepositoryStorage.this.increment.get()).toString());
                return Collections.unmodifiableMap(attributes);
            }

            @Override
            public Resource nextResource() {
                return itres.hasNext() ? (Resource)itres.next() : null;
            }

            @Override
            public void close() {
            }
        };
    }

    public Resource addResource(Resource res) {
        Resource result = super.addResource(res);
        this.increment.incrementAndGet();
        return result;
    }

    public Resource removeResource(ResourceIdentity resid) {
        Resource result = super.removeResource(resid);
        this.increment.incrementAndGet();
        return result;
    }
}

