/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.repository.internal;

import java.io.IOException;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.repository.RepositoryMBean;
import org.jboss.gravia.resource.CompositeDataResourceBuilder;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public final class RepositoryMBeanService {
    private Repository repository;
    private MBeanServer mbeanServer;

    @Activate
    void activate(BundleContext context) throws JMException {
        StandardMBean mbean = new StandardMBean(new RepositoryWrapper(this.repository), RepositoryMBean.class);
        this.mbeanServer.registerMBean(mbean, RepositoryMBean.OBJECT_NAME);
    }

    @Deactivate
    void deactivate() throws JMException {
        this.mbeanServer.unregisterMBean(RepositoryMBean.OBJECT_NAME);
    }

    @Reference
    void bindMBeanServer(MBeanServer service) {
        this.mbeanServer = service;
    }

    void unbindMBeanServer(MBeanServer service) {
        this.mbeanServer = null;
    }

    @Reference
    void bindRepository(Repository service) {
        this.repository = service;
    }

    void unbindRepository(Repository service) {
        this.repository = null;
    }

    static class RepositoryWrapper
    implements RepositoryMBean {
        private final Repository repository;

        RepositoryWrapper(Repository repository) {
            this.repository = repository;
        }

        @Override
        public String getName() {
            return this.repository.getName();
        }

        @Override
        public TabularData findProviders(String namespace, String nsvalue, Map<String, Object> attributes, Map<String, String> directives) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompositeData addResource(CompositeData resData) throws IOException {
            Resource resource = new CompositeDataResourceBuilder(resData).getResource();
            return (CompositeData)this.repository.addResource(resource).adapt(CompositeData.class);
        }

        @Override
        public CompositeData removeResource(String identity) {
            ResourceIdentity resid = ResourceIdentity.fromString((String)identity);
            Resource resource = this.repository.removeResource(resid);
            return resource != null ? (CompositeData)resource.adapt(CompositeData.class) : null;
        }

        @Override
        public CompositeData getResource(String identity) {
            ResourceIdentity resid = ResourceIdentity.fromString((String)identity);
            Resource resource = this.repository.getResource(resid);
            return resource != null ? (CompositeData)resource.adapt(CompositeData.class) : null;
        }
    }
}

