/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resolver;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jboss.gravia.resolver.PreferencePolicy;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.Version;
import org.jboss.gravia.resource.Wiring;
import org.jboss.gravia.resource.spi.AbstractCapability;

public class DefaultPreferencePolicy
implements PreferencePolicy {
    private final Comparator<Capability> comparator;

    public DefaultPreferencePolicy(final Map<Resource, Wiring> wirings) {
        this.comparator = new Comparator<Capability>(){

            @Override
            public int compare(Capability cap1, Capability cap2) {
                if (wirings != null) {
                    Wiring w1 = (Wiring)wirings.get(cap1.getResource());
                    Wiring w2 = (Wiring)wirings.get(cap2.getResource());
                    if (w1 != null && w2 == null) {
                        return -1;
                    }
                    if (w1 == null && w2 != null) {
                        return 1;
                    }
                }
                Version v1 = AbstractCapability.getVersion((Capability)cap1, (String)"version");
                Version v2 = AbstractCapability.getVersion((Capability)cap2, (String)"version");
                return v2.compareTo(v1);
            }
        };
    }

    @Override
    public void sort(List<Capability> providers) {
        Collections.sort(providers, this.comparator);
    }

    @Override
    public Comparator<Capability> getComparator() {
        return this.comparator;
    }
}

