/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resolver.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.gravia.resolver.Environment;
import org.jboss.gravia.resolver.PreferencePolicy;
import org.jboss.gravia.resolver.ResolveContext;
import org.jboss.gravia.resolver.spi.AbstractEnvironment;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.Wiring;
import org.jboss.gravia.utils.NotNullException;

public abstract class AbstractResolveContext
implements ResolveContext {
    private final Environment environment;
    private final List<Resource> mandatory;
    private final List<Resource> optional;
    private PreferencePolicy preferencePolicy;

    public AbstractResolveContext(Environment environment, Set<Resource> manres, Set<Resource> optres) {
        Resource res;
        NotNullException.assertValue((Object)environment, (String)"environment");
        this.environment = environment;
        this.mandatory = new ArrayList<Resource>(manres != null ? manres : Collections.emptyList());
        this.optional = new ArrayList<Resource>(optres != null ? optres : Collections.emptyList());
        for (Resource res2 : this.mandatory) {
            if (environment.getResource(res2.getIdentity()) != null) continue;
            throw new IllegalArgumentException("Resource not in provided store: " + res2);
        }
        for (Resource res2 : this.optional) {
            if (environment.getResource(res2.getIdentity()) != null) continue;
            throw new IllegalArgumentException("Resource not in provided store: " + res2);
        }
        Map<Resource, Wiring> wirings = this.getWirings();
        Iterator<Resource> itres = this.mandatory.iterator();
        while (itres.hasNext()) {
            res = itres.next();
            if (wirings.get(res) == null) continue;
            itres.remove();
        }
        itres = this.optional.iterator();
        while (itres.hasNext()) {
            res = itres.next();
            if (wirings.get(res) == null) continue;
            itres.remove();
        }
    }

    protected abstract PreferencePolicy createPreferencePolicy();

    private PreferencePolicy getPreferencePolicyInternal() {
        if (this.preferencePolicy == null) {
            this.preferencePolicy = this.createPreferencePolicy();
        }
        return this.preferencePolicy;
    }

    @Override
    public Collection<Resource> getMandatoryResources() {
        return Collections.unmodifiableList(this.mandatory);
    }

    @Override
    public Collection<Resource> getOptionalResources() {
        return Collections.unmodifiableList(this.optional);
    }

    @Override
    public boolean isEffective(Requirement req) {
        String effective = (String)req.getDirectives().get("effective");
        return effective == null || effective.equals("resolve");
    }

    @Override
    public Map<Resource, Wiring> getWirings() {
        return this.environment.getWirings();
    }

    void putWiring(Resource resource, Wiring wiring) {
        AbstractEnvironment absenv = AbstractEnvironment.assertAbstractEnvironment(this.environment);
        absenv.putWiring(resource, wiring);
    }

    @Override
    public List<Capability> findProviders(Requirement req) {
        ArrayList<Capability> result = new ArrayList<Capability>();
        result.addAll(this.environment.findProviders(req));
        this.getPreferencePolicyInternal().sort(result);
        return result;
    }
}

