/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.spi.AttributeValueHandler;
import org.jboss.gravia.resource.spi.ElementParser;

public class ManifestResourceBuilder
extends DefaultResourceBuilder {
    public ManifestResourceBuilder load(Manifest manifest) {
        Attributes mainAttributes = manifest.getMainAttributes();
        for (Object key : mainAttributes.keySet()) {
            String namespace;
            LinkedHashMap<String, String> dirs;
            LinkedHashMap<String, Object> atts;
            Attributes.Name name = (Attributes.Name)key;
            String value = mainAttributes.getValue(name);
            if ("Gravia-Identity".equals(name.toString())) {
                LinkedHashMap<String, Object> atts2 = new LinkedHashMap<String, Object>();
                LinkedHashMap<String, String> dirs2 = new LinkedHashMap<String, String>();
                String symbolicName = this.parseParameterizedValue(value, atts2, dirs2);
                this.addIdentityCapability(symbolicName, null, atts2, dirs2);
                continue;
            }
            if ("Gravia-IdentityRequirement".equals(name.toString())) {
                for (String part : ElementParser.parseDelimitedString(value, ',')) {
                    atts = new LinkedHashMap<String, Object>();
                    dirs = new LinkedHashMap<String, String>();
                    String symbolicName = this.parseParameterizedValue(part, atts, dirs);
                    this.addIdentityRequirement(symbolicName, null, atts, dirs);
                }
                continue;
            }
            if ("Gravia-Capability".equals(name.toString())) {
                for (String part : ElementParser.parseDelimitedString(value, ',')) {
                    atts = new LinkedHashMap();
                    dirs = new LinkedHashMap();
                    namespace = this.parseParameterizedValue(part, atts, dirs);
                    this.addCapability(namespace, atts, dirs);
                }
                continue;
            }
            if (!"Gravia-Requirement".equals(name.toString())) continue;
            for (String part : ElementParser.parseDelimitedString(value, ',')) {
                atts = new LinkedHashMap();
                dirs = new LinkedHashMap();
                namespace = this.parseParameterizedValue(part, atts, dirs);
                this.addRequirement(namespace, atts, dirs);
            }
        }
        return this;
    }

    private String parseParameterizedValue(String line, Map<String, Object> atts, Map<String, String> dirs) {
        String mainvalue = null;
        for (String part : ElementParser.parseDelimitedString(line, ';', true)) {
            Object value;
            int index;
            if (part.indexOf(":=") > 0) {
                index = part.indexOf(":=");
                String key = part.substring(0, index);
                value = this.unquote(part.substring(index + 2));
                dirs.put(key.trim(), (String)value);
                continue;
            }
            if (part.indexOf(61) > 0) {
                index = part.indexOf(61);
                String keystr = part.substring(0, index);
                value = this.getAttributeValue(keystr, part.substring(index + 1));
                atts.put(this.getAttributeKey(keystr), value);
                continue;
            }
            if (mainvalue == null) {
                mainvalue = part;
                continue;
            }
            throw new IllegalArgumentException("Cannot parse: " + line);
        }
        return mainvalue;
    }

    private String getAttributeKey(String keystr) {
        String[] parts = keystr.split(":");
        return parts[0].trim();
    }

    private Object getAttributeValue(String key, String valstr) {
        String[] parts = key.split(":");
        if (parts.length == 1) {
            return this.unquote(valstr);
        }
        String typespec = parts[1].trim();
        if (typespec.startsWith("List")) {
            parts = typespec.split("[<>]");
            typespec = "List<" + (parts.length > 1 ? parts[1].trim() : "String") + ">";
        }
        AttributeValueHandler.AttributeValue attval = AttributeValueHandler.readAttributeValue(typespec, this.unquote(valstr));
        return attval.getValue();
    }

    private String unquote(String value) {
        if ((value = value.trim()).startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }
}

