/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.gravia.resource.Attachable;
import org.jboss.gravia.resource.AttachmentKey;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.Version;
import org.jboss.gravia.resource.Wiring;
import org.jboss.gravia.resource.spi.AbstractCapability;
import org.jboss.gravia.resource.spi.AbstractRequirement;
import org.jboss.gravia.resource.spi.AttachableSupport;

public abstract class AbstractResource
implements Resource {
    private final List<AbstractCapability> capabilities = new ArrayList<AbstractCapability>();
    private final List<AbstractRequirement> requirements = new ArrayList<AbstractRequirement>();
    private final AtomicBoolean mutable = new AtomicBoolean(true);
    private Capability identityCapability;
    private ResourceIdentity identity;
    private Attachable attachments;
    private Wiring wiring;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCapability(AbstractCapability cap) {
        List<AbstractCapability> list = this.capabilities;
        synchronized (list) {
            this.assertMutable();
            this.capabilities.add(cap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRequirement(AbstractRequirement req) {
        List<AbstractRequirement> list = this.requirements;
        synchronized (list) {
            this.assertMutable();
            this.requirements.add(req);
        }
    }

    @Override
    public <T> T adapt(Class<T> type) {
        AbstractResource result = null;
        if (type.isAssignableFrom(this.getClass())) {
            result = this;
        }
        return (T)result;
    }

    @Override
    public Capability getIdentityCapability() {
        if (this.identityCapability == null) {
            List<Capability> icaps = this.getCapabilities("gravia.identity");
            if (icaps.size() > 1) {
                throw new IllegalStateException("Multiple identity capabilities");
            }
            if (icaps.size() < 1) {
                throw new IllegalStateException("No identity capability");
            }
            Capability icap = icaps.get(0);
            Object version = icap.getAttribute("version");
            if (!(version instanceof Version)) {
                version = version == null ? Version.emptyVersion : Version.parseVersion(version.toString());
                icap.getAttributes().put("version", version);
            }
            this.identityCapability = icap;
        }
        return this.identityCapability;
    }

    @Override
    public ResourceIdentity getIdentity() {
        if (this.identity == null) {
            Capability icap = this.getIdentityCapability();
            String symbolicName = (String)icap.getAttribute("gravia.identity");
            Version version = (Version)icap.getAttribute("version");
            this.identity = ResourceIdentity.create(symbolicName, version);
        }
        return this.identity;
    }

    protected void setMutable(boolean flag) {
        this.mutable.set(flag);
    }

    protected boolean isMutable() {
        return this.mutable.get();
    }

    void assertMutable() {
        if (!this.isMutable()) {
            throw new IllegalStateException("Invalid access to immutable resource");
        }
    }

    void assertImmutable() {
        if (this.isMutable()) {
            throw new IllegalStateException("Invalid access to mutable resource");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Capability> getCapabilities(String namespace) {
        ArrayList<Capability> result = new ArrayList<Capability>();
        List<AbstractCapability> list = this.capabilities;
        synchronized (list) {
            for (Capability capability : this.capabilities) {
                if (namespace != null && !namespace.equals(capability.getNamespace())) continue;
                result.add(capability);
            }
        }
        return Collections.unmodifiableList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Requirement> getRequirements(String namespace) {
        ArrayList<Requirement> result = new ArrayList<Requirement>();
        List<AbstractRequirement> list = this.requirements;
        synchronized (list) {
            for (Requirement requirement : this.requirements) {
                if (namespace != null && !namespace.equals(requirement.getNamespace())) continue;
                result.add(requirement);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Wiring getWiring() {
        return this.wiring;
    }

    public void setWiring(Wiring wiring) {
        this.wiring = wiring;
    }

    @Override
    public <T> T putAttachment(AttachmentKey<T> key, T value) {
        return this.getAttachmentsInternal().putAttachment(key, value);
    }

    @Override
    public <T> T getAttachment(AttachmentKey<T> key) {
        return this.getAttachmentsInternal().getAttachment(key);
    }

    @Override
    public <T> T removeAttachment(AttachmentKey<T> key) {
        return this.getAttachmentsInternal().getAttachment(key);
    }

    private Attachable getAttachmentsInternal() {
        if (this.attachments == null) {
            this.attachments = new AttachableSupport();
        }
        return this.attachments;
    }

    void validate() {
        this.getIdentity();
        for (Capability cap : this.getCapabilities(null)) {
            ((AbstractCapability)cap).validate();
        }
        for (Requirement req : this.getRequirements(null)) {
            ((AbstractRequirement)req).validate();
        }
    }

    protected String getSimpleTypeName() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        ResourceIdentity id = this.identity;
        String idstr = id != null ? id.getSymbolicName() + ":" + id.getVersion() : "anonymous";
        return this.getSimpleTypeName() + "[" + idstr + "]";
    }
}

