/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource.spi;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceBuilder;
import org.jboss.gravia.resource.Version;
import org.jboss.gravia.resource.VersionRange;
import org.jboss.gravia.resource.spi.AbstractCapability;
import org.jboss.gravia.resource.spi.AbstractRequirement;
import org.jboss.gravia.resource.spi.AbstractResource;

public abstract class AbstractResourceBuilder
implements ResourceBuilder {
    private AbstractResource resource;

    protected abstract AbstractResource createResource();

    protected abstract AbstractCapability createCapability(AbstractResource var1, String var2, Map<String, Object> var3, Map<String, String> var4);

    protected abstract AbstractRequirement createRequirement(AbstractResource var1, String var2, Map<String, Object> var3, Map<String, String> var4);

    @Override
    public Capability addIdentityCapability(String symbolicName, String version) {
        return this.addIdentityCapability(symbolicName, Version.parseVersion(version), null, null);
    }

    @Override
    public Capability addIdentityCapability(String symbolicName, Version version) {
        return this.addIdentityCapability(symbolicName, version, null, null);
    }

    @Override
    public Capability addIdentityCapability(String symbolicName, Version version, Map<String, Object> atts, Map<String, String> dirs) {
        Capability icap = this.addCapability("gravia.identity", symbolicName);
        if (version != null) {
            icap.getAttributes().put("version", version);
        }
        if (atts != null) {
            icap.getAttributes().putAll(atts);
        }
        if (dirs != null) {
            icap.getDirectives().putAll(dirs);
        }
        return icap;
    }

    @Override
    public Capability addCapability(String namespace, String nsvalue) {
        return this.addCapability(namespace, Collections.singletonMap(namespace, nsvalue), null);
    }

    @Override
    public Capability addCapability(String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        AbstractResource resource = this.getResourceInternal();
        AbstractCapability cap = this.createCapability(resource, namespace, this.mutableAttributes(atts), this.mutableDirectives(dirs));
        resource.addCapability(cap);
        return cap;
    }

    @Override
    public Requirement addIdentityRequirement(String symbolicName, String version) {
        return this.addIdentityRequirement(symbolicName, new VersionRange(version), null, null);
    }

    @Override
    public Requirement addIdentityRequirement(String symbolicName, VersionRange version) {
        return this.addIdentityRequirement(symbolicName, version, null, null);
    }

    @Override
    public Requirement addIdentityRequirement(String symbolicName, VersionRange version, Map<String, Object> atts, Map<String, String> dirs) {
        Requirement ireq = this.addRequirement("gravia.identity", symbolicName);
        if (version != null) {
            ireq.getAttributes().put("version", version);
        }
        if (atts != null) {
            ireq.getAttributes().putAll(atts);
        }
        if (dirs != null) {
            ireq.getDirectives().putAll(dirs);
        }
        return ireq;
    }

    @Override
    public Requirement addRequirement(String namespace, String nsvalue) {
        return this.addRequirement(namespace, Collections.singletonMap(namespace, nsvalue), null);
    }

    @Override
    public Requirement addRequirement(String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        AbstractResource resource = this.getResourceInternal();
        AbstractRequirement req = this.createRequirement(resource, namespace, this.mutableAttributes(atts), this.mutableDirectives(dirs));
        resource.addRequirement(req);
        return req;
    }

    @Override
    public Resource getResource() {
        AbstractResource resource = this.getResourceInternal();
        resource.validate();
        resource.setMutable(false);
        return resource;
    }

    private Map<String, Object> mutableAttributes(Map<String, Object> atts) {
        return new LinkedHashMap<String, Object>(atts != null ? atts : new LinkedHashMap());
    }

    private Map<String, String> mutableDirectives(Map<String, String> dirs) {
        return new LinkedHashMap<String, String>(dirs != null ? dirs : new LinkedHashMap());
    }

    private AbstractResource getResourceInternal() {
        if (this.resource == null) {
            this.resource = this.createResource();
        }
        return this.resource;
    }
}

