/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.Wire;
import org.jboss.gravia.resource.Wiring;

public class AbstractWiring
implements Wiring {
    private final Resource resource;
    private final List<Wire> required = new ArrayList<Wire>();
    private final Map<String, List<Wire>> provided = new HashMap<String, List<Wire>>();

    public AbstractWiring(Resource resource, List<Wire> reqwires, List<Wire> provwires) {
        if (resource == null) {
            throw new IllegalArgumentException("Null resource");
        }
        this.resource = resource;
        if (reqwires != null) {
            for (Wire wire : reqwires) {
                this.addRequiredWire(wire);
            }
        }
        if (provwires != null) {
            for (Wire wire : provwires) {
                this.addProvidedWire(wire);
            }
        }
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    public void addRequiredWire(Wire wire) {
        this.required.add(wire);
    }

    public void addProvidedWire(Wire wire) {
        Capability cap = wire.getCapability();
        List<Wire> nswires = this.provided.get(cap.getNamespace());
        if (nswires == null) {
            nswires = new ArrayList<Wire>();
            this.provided.put(cap.getNamespace(), nswires);
        }
        int index = 0;
        if (nswires.size() > 0) {
            int capindex = this.getCapabilityIndex(cap);
            for (Wire aux : nswires) {
                int auxindex = this.getCapabilityIndex(aux.getCapability());
                if (auxindex >= capindex) continue;
                ++index;
            }
        }
        nswires.add(index, wire);
    }

    private int getCapabilityIndex(Capability cap) {
        return this.getResource().getCapabilities(cap.getNamespace()).indexOf(cap);
    }

    @Override
    public List<Capability> getResourceCapabilities(String namespace) {
        ArrayList<Capability> result = new ArrayList<Capability>();
        for (Wire wire : this.getProvidedResourceWires(namespace)) {
            Capability req = wire.getCapability();
            result.add(req);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Requirement> getResourceRequirements(String namespace) {
        ArrayList<Requirement> result = new ArrayList<Requirement>();
        for (Wire wire : this.getRequiredResourceWires(namespace)) {
            Requirement req = wire.getRequirement();
            result.add(req);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Wire> getProvidedResourceWires(String namespace) {
        ArrayList<Wire> result = new ArrayList<Wire>();
        if (namespace != null) {
            List<Wire> nswires = this.provided.get(namespace);
            if (nswires != null) {
                result.addAll(nswires);
            }
        } else {
            for (List<Wire> wire : this.provided.values()) {
                result.addAll(wire);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Wire> getRequiredResourceWires(String namespace) {
        ArrayList<Wire> result = new ArrayList<Wire>();
        for (Wire wire : this.required) {
            Requirement req = wire.getRequirement();
            if (namespace != null && !namespace.equals(req.getNamespace())) continue;
            result.add(wire);
        }
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        return "Wiring[" + this.resource + "]";
    }
}

