/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;

public final class CompositeDataResourceType {
    public static final String TYPE_NAME = "ResourceType";
    public static final String ITEM_IDENTITY = "identity";
    public static final String ITEM_CAPABILITIES = "capabilities";
    public static final String ITEM_REQUIREMENTS = "requirements";
    private static final CompositeType compositeType;

    public static CompositeType getCompositeType() {
        return compositeType;
    }

    public CompositeData getCompositeData(Resource res) throws OpenDataException {
        String identity = res.getIdentity().toString();
        List<Capability> caps = res.getCapabilities(null);
        List<Requirement> reqs = res.getRequirements(null);
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(identity);
        items.add(new CapabilitiesType().getCompositeData(caps));
        items.add(new RequirementsType().getCompositeData(reqs));
        Object[] itemValues = items.toArray(new Object[items.size()]);
        return new CompositeDataSupport(compositeType, CompositeDataResourceType.getItemNames(), itemValues);
    }

    public static String[] getItemNames() {
        return new String[]{ITEM_IDENTITY, ITEM_CAPABILITIES, ITEM_REQUIREMENTS};
    }

    public static OpenType<?>[] getItemTypes() throws OpenDataException {
        ArrayList<OpenType> itemTypes = new ArrayList<OpenType>();
        itemTypes.add(SimpleType.STRING);
        itemTypes.add(CapabilitiesType.getArrayType());
        itemTypes.add(RequirementsType.getArrayType());
        return itemTypes.toArray(new OpenType[itemTypes.size()]);
    }

    static {
        try {
            compositeType = new CompositeType(TYPE_NAME, TYPE_NAME, CompositeDataResourceType.getItemNames(), CompositeDataResourceType.getItemNames(), CompositeDataResourceType.getItemTypes());
        }
        catch (OpenDataException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static final class DirectiveType {
        public static final String TYPE_NAME = "DirectiveType";
        public static final String ITEM_KEY = "key";
        public static final String ITEM_VALUE = "value";
        private static final CompositeType compositeType;

        public static CompositeType getCompositeType() {
            return compositeType;
        }

        public static String[] getItemNames() {
            return new String[]{ITEM_KEY, ITEM_VALUE};
        }

        public static OpenType<?>[] getItemTypes() {
            return new OpenType[]{SimpleType.STRING, SimpleType.STRING};
        }

        static {
            try {
                compositeType = new CompositeType(TYPE_NAME, TYPE_NAME, DirectiveType.getItemNames(), DirectiveType.getItemNames(), DirectiveType.getItemTypes());
            }
            catch (OpenDataException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public static final class DirectivesType {
        public static final String TYPE_NAME = "DirectivesType";
        public static final String ITEM_NAME = "directives";
        private static final ArrayType<CompositeType> arrayType;

        public static ArrayType<CompositeType> getArrayType() {
            return arrayType;
        }

        public CompositeData[] getCompositeData(Map<String, String> directives) throws OpenDataException {
            CompositeData[] dataArr = new CompositeData[directives.size()];
            String[] itemNames = new String[]{"key", "value"};
            int index = 0;
            for (Map.Entry<String, String> entry : directives.entrySet()) {
                Object[] itemValues = new Object[]{entry.getKey(), entry.getValue()};
                CompositeDataSupport data = new CompositeDataSupport(DirectiveType.getCompositeType(), itemNames, itemValues);
                dataArr[index++] = data;
            }
            return dataArr;
        }

        public static String[] getIndexNames() {
            return new String[]{"key", "value"};
        }

        public static CompositeType getRowType() throws OpenDataException {
            return DirectiveType.getCompositeType();
        }

        static {
            try {
                arrayType = new ArrayType(1, DirectivesType.getRowType());
            }
            catch (OpenDataException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public static final class AttributeType {
        public static final String TYPE_NAME = "AttributeType";
        public static final String ITEM_KEY = "key";
        public static final String ITEM_VALUE = "value";
        private static final CompositeType compositeType;

        public static CompositeType getArrayType() {
            return compositeType;
        }

        public static String[] getItemNames() {
            return new String[]{ITEM_KEY, ITEM_VALUE};
        }

        public static OpenType<?>[] getItemTypes() {
            return new OpenType[]{SimpleType.STRING, SimpleType.STRING};
        }

        static {
            try {
                compositeType = new CompositeType(TYPE_NAME, TYPE_NAME, AttributeType.getItemNames(), AttributeType.getItemNames(), AttributeType.getItemTypes());
            }
            catch (OpenDataException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public static final class AttributesType {
        public static final String TYPE_NAME = "AttributesType";
        public static final String ITEM_NAME = "attributes";
        private static final ArrayType<CompositeType> arrayType;

        public static ArrayType<CompositeType> getArrayType() {
            return arrayType;
        }

        public CompositeData[] getCompositeData(Map<String, Object> attributes) throws OpenDataException {
            CompositeData[] dataArr = new CompositeData[attributes.size()];
            String[] itemNames = new String[]{"key", "value"};
            int index = 0;
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                Object[] itemValues = new Object[]{entry.getKey(), entry.getValue().toString()};
                CompositeDataSupport data = new CompositeDataSupport(AttributeType.getArrayType(), itemNames, itemValues);
                dataArr[index++] = data;
            }
            return dataArr;
        }

        public static String[] getIndexNames() {
            return new String[]{"key", "value"};
        }

        public static CompositeType getRowType() throws OpenDataException {
            return AttributeType.getArrayType();
        }

        static {
            try {
                arrayType = new ArrayType(1, AttributesType.getRowType());
            }
            catch (OpenDataException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public static final class RequirementType {
        public static final String TYPE_NAME = "RequirementType";
        public static final String ITEM_NAMESPACE = "namespace";
        public static final String ITEM_ATTRIBUTES = "attributes";
        public static final String ITEM_DIRECTIVES = "directives";
        private static final CompositeType compositeType;

        public static CompositeType getCompositeType() {
            return compositeType;
        }

        public CompositeData getCompositeData(Requirement req) throws OpenDataException {
            String namespace = req.getNamespace();
            CompositeData[] attsData = new AttributesType().getCompositeData(req.getAttributes());
            CompositeData[] dirsData = new DirectivesType().getCompositeData(req.getDirectives());
            Object[] itemValues = new Object[]{namespace, attsData, dirsData};
            return new CompositeDataSupport(compositeType, RequirementType.getItemNames(), itemValues);
        }

        public static String[] getItemNames() {
            return new String[]{ITEM_NAMESPACE, ITEM_ATTRIBUTES, ITEM_DIRECTIVES};
        }

        public static OpenType<?>[] getItemTypes() throws OpenDataException {
            ArrayType<CompositeType> attsType = AttributesType.getArrayType();
            ArrayType<CompositeType> dirsType = DirectivesType.getArrayType();
            return new OpenType[]{SimpleType.STRING, attsType, dirsType};
        }

        static {
            try {
                compositeType = new CompositeType(TYPE_NAME, TYPE_NAME, RequirementType.getItemNames(), RequirementType.getItemNames(), RequirementType.getItemTypes());
            }
            catch (OpenDataException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public static final class RequirementsType {
        public static final String TYPE_NAME = "RequirementsType";
        public static final String ITEM_NAME = "requirements";
        private static final ArrayType<CompositeType> arrayType;

        public static ArrayType<CompositeType> getArrayType() {
            return arrayType;
        }

        public CompositeData[] getCompositeData(List<Requirement> requirements) throws OpenDataException {
            CompositeData[] itemValues = new CompositeData[requirements.size()];
            for (int index = 0; index < requirements.size(); ++index) {
                Requirement req = requirements.get(index);
                itemValues[index] = new RequirementType().getCompositeData(req);
            }
            return itemValues;
        }

        static {
            try {
                arrayType = new ArrayType(1, RequirementType.getCompositeType());
            }
            catch (OpenDataException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public static final class CapabilityType {
        public static final String TYPE_NAME = "CapabilityType";
        public static final String ITEM_NAMESPACE = "namespace";
        public static final String ITEM_ATTRIBUTES = "attributes";
        public static final String ITEM_DIRECTIVES = "directives";
        private static final CompositeType compositeType;

        public static CompositeType getCompositeType() {
            return compositeType;
        }

        public CompositeData getCompositeData(Capability cap) throws OpenDataException {
            String namespace = cap.getNamespace();
            CompositeData[] attsData = new AttributesType().getCompositeData(cap.getAttributes());
            CompositeData[] dirsData = new DirectivesType().getCompositeData(cap.getDirectives());
            Object[] itemValues = new Object[]{namespace, attsData, dirsData};
            return new CompositeDataSupport(compositeType, CapabilityType.getItemNames(), itemValues);
        }

        public static String[] getItemNames() {
            return new String[]{ITEM_NAMESPACE, ITEM_ATTRIBUTES, ITEM_DIRECTIVES};
        }

        public static OpenType<?>[] getItemTypes() throws OpenDataException {
            ArrayType<CompositeType> attsType = AttributesType.getArrayType();
            ArrayType<CompositeType> dirsType = DirectivesType.getArrayType();
            return new OpenType[]{SimpleType.STRING, attsType, dirsType};
        }

        static {
            try {
                compositeType = new CompositeType(TYPE_NAME, TYPE_NAME, CapabilityType.getItemNames(), CapabilityType.getItemNames(), CapabilityType.getItemTypes());
            }
            catch (OpenDataException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public static final class CapabilitiesType {
        public static final String TYPE_NAME = "CapabilitiesType";
        public static final String ITEM_NAME = "capabilities";
        private static final ArrayType<CompositeType> arrayType;

        public static ArrayType<CompositeType> getArrayType() {
            return arrayType;
        }

        public CompositeData[] getCompositeData(List<Capability> caps) throws OpenDataException {
            CompositeData[] itemValues = new CompositeData[caps.size()];
            for (int index = 0; index < caps.size(); ++index) {
                Capability cap = caps.get(index);
                itemValues[index] = new CapabilityType().getCompositeData(cap);
            }
            return itemValues;
        }

        static {
            try {
                arrayType = new ArrayType(1, CapabilityType.getCompositeType());
            }
            catch (OpenDataException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

