/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.RuntimeFactory;
import org.jboss.gravia.runtime.util.NotNullException;

public final class RuntimeLocator {
    private static AtomicReference<Runtime> runtimeReference = new AtomicReference();

    private RuntimeLocator() {
    }

    public static Runtime getRuntime() {
        return runtimeReference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Runtime createRuntime(RuntimeFactory factory, PropertiesProvider props) {
        NotNullException.assertValue(factory, "factory");
        NotNullException.assertValue(props, "props");
        AtomicReference<Runtime> atomicReference = runtimeReference;
        synchronized (atomicReference) {
            Runtime runtime = runtimeReference.get();
            if (runtime != null) {
                throw new IllegalStateException("Runtime already created: " + runtime);
            }
            runtime = factory.createRuntime(props);
            runtimeReference.set(runtime);
            return runtime;
        }
    }

    public static Runtime createRuntime(PropertiesProvider props) {
        NotNullException.assertValue(props, "props");
        RuntimeFactory factory = null;
        String className = (String)props.getProperty(RuntimeFactory.class.getName());
        if (className != null) {
            try {
                factory = (RuntimeFactory)Class.forName(className).newInstance();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot load runtime factory: " + className, ex);
            }
        } else {
            ServiceLoader<RuntimeFactory> loader = ServiceLoader.load(RuntimeFactory.class, RuntimeLocator.class.getClassLoader());
            Iterator<RuntimeFactory> iterator = loader.iterator();
            if (iterator.hasNext()) {
                factory = iterator.next();
            }
        }
        return RuntimeLocator.createRuntime(factory, props);
    }

    public static void releaseRuntime() {
        runtimeReference.set(null);
    }
}

