/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.spi;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.SecurityActions;
import org.jboss.gravia.utils.NotNullException;

public class DefaultPropertiesProvider
implements PropertiesProvider {
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final boolean systemPropertyDelegation;

    public DefaultPropertiesProvider() {
        this(DefaultPropertiesProvider.getDefaultProperties(), true);
    }

    public DefaultPropertiesProvider(Properties props, boolean sysprops) {
        this(DefaultPropertiesProvider.propsToMap(props), sysprops);
    }

    public DefaultPropertiesProvider(Map<String, Object> props, boolean sysprops) {
        NotNullException.assertValue(props, (String)"props");
        this.systemPropertyDelegation = sysprops;
        this.properties.putAll(props);
    }

    @Override
    public Object getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        Object value = this.properties.get(key);
        if (value == null && this.systemPropertyDelegation) {
            value = SecurityActions.getSystemProperty(key, null);
        }
        return value != null ? value : defaultValue;
    }

    private static Properties getDefaultProperties() {
        URL configURL = null;
        String sysprop = SecurityActions.getSystemProperty("gravia.properties", null);
        if (sysprop != null) {
            try {
                configURL = new URL(sysprop);
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException("Invalid configuration URL: " + sysprop);
            }
        }
        if (configURL == null) {
            ClassLoader classLoader = DefaultPropertiesProvider.class.getClassLoader();
            configURL = classLoader.getResource("gravia.properties");
        }
        Properties props = new Properties();
        if (configURL != null) {
            try {
                props.load(configURL.openStream());
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot load configuration from: " + configURL, ex);
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> propsToMap(Properties props) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Properties properties = props;
        synchronized (properties) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = entry.getKey().toString();
                Object value = entry.getValue();
                result.put(key, value);
            }
        }
        return result;
    }
}

