/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.embedded.internal;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.ServiceLoader;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jboss.gravia.resource.Attachable;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ModuleException;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.runtime.embedded.internal.EmbeddedLogServiceFactory;
import org.jboss.gravia.runtime.embedded.internal.EmbeddedModule;
import org.jboss.gravia.runtime.embedded.internal.RuntimeServicesManager;
import org.jboss.gravia.runtime.embedded.internal.RuntimeStorageHandler;
import org.jboss.gravia.runtime.embedded.internal.SystemModule;
import org.jboss.gravia.runtime.spi.AbstractModule;
import org.jboss.gravia.runtime.spi.AbstractRuntime;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.RuntimeEventsManager;
import org.jboss.gravia.runtime.spi.RuntimeLogger;
import org.jboss.gravia.runtime.spi.RuntimePlugin;
import org.osgi.service.log.LogService;

public class EmbeddedRuntime
extends AbstractRuntime {
    private final RuntimeServicesManager serviceManager;
    private final RuntimeStorageHandler storageHandler;
    private final List<ServiceRegistration<?>> systemServices = new ArrayList();

    public EmbeddedRuntime(PropertiesProvider propertiesProvider, Attachable context) {
        super(propertiesProvider);
        this.serviceManager = new RuntimeServicesManager(this.adapt(RuntimeEventsManager.class));
        this.storageHandler = new RuntimeStorageHandler(propertiesProvider, true);
        Resource resource = new DefaultResourceBuilder().addIdentityCapability(this.getSystemIdentity()).getResource();
        try {
            this.installModule(EmbeddedRuntime.class.getClassLoader(), resource, null, context);
        }
        catch (ModuleException ex) {
            throw new IllegalStateException("Cannot install system module", ex);
        }
    }

    public void init() {
        this.assertNoShutdown();
        ModuleContext syscontext = this.adapt(ModuleContext.class);
        this.systemServices.add(syscontext.registerService(LogService.class.getName(), (Object)new EmbeddedLogServiceFactory(), null));
        MBeanServer mbeanServer = this.findOrCreateMBeanServer();
        this.systemServices.add(syscontext.registerService(MBeanServer.class, (Object)mbeanServer, null));
        ArrayList<Module> pluginModules = new ArrayList<Module>();
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ServiceLoader<RuntimePlugin> services = ServiceLoader.load(RuntimePlugin.class, EmbeddedRuntime.class.getClassLoader());
        for (RuntimePlugin plugin : services) {
            try {
                Module module = plugin.installPluginModule((Runtime)this, classLoader);
                if (module == null) continue;
                pluginModules.add(module);
            }
            catch (ModuleException ex) {
                RuntimeLogger.LOGGER.error("Cannot load plugin: " + plugin.getClass().getName(), (Throwable)ex);
            }
        }
        for (Module module : pluginModules) {
            try {
                module.start();
            }
            catch (ModuleException ex) {
                RuntimeLogger.LOGGER.error("Cannot start plugin: " + module, (Throwable)ex);
            }
        }
    }

    protected AbstractModule createModule(ClassLoader classLoader, Resource resource, Dictionary<String, String> headers, Attachable context) {
        this.assertNoShutdown();
        AbstractModule module = resource != null && resource.getIdentity().equals((Object)this.getSystemIdentity()) ? new SystemModule(this, classLoader, resource) : new EmbeddedModule(this, classLoader, resource, headers);
        return module;
    }

    protected ModuleEntriesProvider getDefaultEntriesProvider(Module module, Attachable context) {
        return null;
    }

    public <A> A adapt(Class<A> type) {
        Object result = super.adapt(type);
        if (result == null) {
            if (type.isAssignableFrom(RuntimeServicesManager.class)) {
                result = this.serviceManager;
            } else if (type.isAssignableFrom(RuntimeStorageHandler.class)) {
                result = this.storageHandler;
            }
        }
        return (A)result;
    }

    protected void uninstallModule(Module module) {
        super.uninstallModule(module);
    }

    protected void doShutdown() {
        super.doShutdown();
        for (ServiceRegistration<?> sreg : this.systemServices) {
            sreg.unregister();
        }
    }

    private MBeanServer findOrCreateMBeanServer() {
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() == 1) {
            MBeanServer mbeanServer = serverArr.get(0);
            RuntimeLogger.LOGGER.debug("Found MBeanServer: {}", (Object)mbeanServer.getDefaultDomain());
            return mbeanServer;
        }
        if (serverArr.size() > 1) {
            RuntimeLogger.LOGGER.info("Multiple MBeanServer instances: {}", serverArr);
        }
        RuntimeLogger.LOGGER.debug("Using the platform MBeanServer");
        return ManagementFactory.getPlatformMBeanServer();
    }
}

