/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.identity.idm.impl.api.query;

import org.jboss.identity.idm.api.query.RoleQuery;
import org.jboss.identity.idm.api.query.GroupQuery;
import org.jboss.identity.idm.api.query.UnsupportedQueryCriterium;
import org.jboss.identity.idm.api.query.QueryException;
import org.jboss.identity.idm.api.SortOrder;
import org.jboss.identity.idm.api.Role;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.RoleType;
import org.jboss.identity.idm.api.IdentityType;
import org.jboss.identity.idm.impl.api.session.IdentitySessionImpl;
import org.jboss.identity.idm.impl.api.model.SimpleUser;
import org.jboss.identity.idm.impl.api.model.GroupId;
import org.jboss.identity.idm.impl.api.model.SimpleGroup;
import org.jboss.identity.idm.impl.api.model.SimpleRoleType;
import org.jboss.identity.idm.impl.NotYetImplementedException;

import java.util.Collection;
import java.util.List;

/**
 * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
 * @version : 0.1 $
 */
public class RoleQueryImpl extends AbstractQuery implements RoleQuery
{

   private User user;

   private Group group;

   private RoleType roleType;

   public RoleQueryImpl(IdentitySessionImpl identitySession)
   {
      super(identitySession);
   }

   public Collection<Role> execute() throws QueryException
   {
      throw new NotYetImplementedException();

   }

   public Role uniqueResult() throws QueryException
   {
      throw new NotYetImplementedException();
   }

   public List<Role> list() throws QueryException
   {
      throw new NotYetImplementedException();
   }

   public RoleQuery setUser(User user)
   {
      checkNotNullArgument(user, "User");
      this.user = user;
      return this;
   }

   public RoleQuery setUser(String id)
   {
      checkNotNullArgument(id, "User id");
      this.user = new SimpleUser(id);
      return this;
   }

   public RoleQuery setGroup(Group group)
   {
      checkNotNullArgument(group, "Group");
      this.group = group;
      return this;
   }

   public RoleQuery setGroup(String id)
   {
      checkNotNullArgument(id, "Group id");
      this.group = new SimpleGroup(new GroupId(id));
      return this;
   }

   public RoleQuery setRoleType(RoleType roleType)
   {
      checkNotNullArgument(roleType, "RoleType");
      this.roleType = roleType;
      return this;
   }

   public RoleQuery setRoleType(String roleTypeName)
   {
      checkNotNullArgument(roleTypeName, "RoleType name");
      this.roleType = new SimpleRoleType(roleTypeName);
      return this;
   }

   public RoleQuery setIdentityType(IdentityType identityType)
   {
      checkNotNullArgument(identityType, "IdentityType");
      if (identityType instanceof User)
      {
         this.user = (User)identityType;
      }
      else
      {
         this.group = (Group)identityType;
      }
      return this;
   }

   public RoleQuery setIdentityTypeId(String id)
   {
      checkNotNullArgument(id, "IdentityType id");
      IdentityType identityType = createIdentityTypeFromId(id);
      return setIdentityType(identityType);
   }

   public RoleQuery sort(SortOrder order) throws UnsupportedQueryCriterium
   {
      return (RoleQuery)super.sort(order);
   }

   public RoleQuery sortAttributeName(String name) throws UnsupportedQueryCriterium
   {
      return (RoleQuery)super.sortAttributeName(name);
   }

   public RoleQuery page(int firstResult, int maxResults) throws UnsupportedQueryCriterium
   {
      return (RoleQuery)super.page(firstResult, maxResults);
   }

   public RoleQuery attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedQueryCriterium
   {
      return (RoleQuery)super.attributeValuesFilter(attributeName, attributeValue);
   }
}
