/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.identity.idm.impl.api.query;

import org.jboss.identity.idm.api.query.UserQuery;
import org.jboss.identity.idm.api.query.QueryException;
import org.jboss.identity.idm.api.query.UnsupportedQueryCriterium;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.SortOrder;
import org.jboss.identity.idm.impl.api.session.IdentitySessionImpl;
import org.jboss.identity.idm.impl.NotYetImplementedException;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.HashSet;

/**
 * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
 * @version : 0.1 $
 */
public class UserQueryImpl extends AbstractQuery implements UserQuery 
{

   private String userId;

   private Set<Group> groupsAssociatedWith = new HashSet<Group>();

   private Set<Group> groupsConnectedWithRole = new HashSet<Group>();

   private Set<Group> groupsRelated = new HashSet<Group>();

   public UserQueryImpl(IdentitySessionImpl identitySession)
   {
      super(identitySession);
   }

   public Collection<User> execute() throws QueryException
   {
      throw new NotYetImplementedException();
   }

   public User uniqueResult() throws QueryException
   {
      throw new NotYetImplementedException();
   }

   public List<User> list() throws QueryException
   {
      throw new NotYetImplementedException();
   }

   public UserQuery withUserId(String id)
   {
      checkNotNullArgument(id, "User id");
      userId = id;
      return this;
   }

   public UserQuery addAssociatedGroup(Group group)
   {
      checkNotNullArgument(group, "Group");
      groupsAssociatedWith.add(group);
      return this;
   }

   public UserQuery addAssociatedGroup(String id)
   {
      checkNotNullArgument(id, "Group id");
      groupsAssociatedWith.add(createGroupFromId(id));
      return this;
   }

   public UserQuery addAssociatedGroups(Collection<Group> groups)
   {
      checkNotNullArgument(groups, "Groups");
      groupsAssociatedWith.addAll(groups);
      return this;
   }

   public UserQuery addAssociatedGroupsIds(Collection<String> groups)
   {
      checkNotNullArgument(groups, "Groups");
      for (String groupId : groups)
      {
         groupsAssociatedWith.add(createGroupFromId(groupId));
      }
      return this;
   }

   public UserQuery addGroupConnectedWithRole(Group group)
   {
      checkNotNullArgument(group, "Group");
      groupsConnectedWithRole.add(group);
      return this;
   }

   public UserQuery addGroupConnectedWithRole(String id)
   {
      checkNotNullArgument(id, "Group id");
      groupsConnectedWithRole.add(createGroupFromId(id));
      return this;
   }

   public UserQuery addGroupsConnectedWithRole(Collection<Group> groups)
   {
      checkNotNullArgument(groups, "Groups");
      groupsConnectedWithRole.addAll(groups);
      return this;
   }

   public UserQuery addGroupsIdsConnectedWithRole(Collection<String> groups)
   {
      checkNotNullArgument(groups, "Groups");
      for (String groupId : groups)
      {
         groupsConnectedWithRole.add(createGroupFromId(groupId));
      }
      return this;
   }

   public UserQuery addRelatedGroup(Group group)
   {
      checkNotNullArgument(group, "Group");
      groupsRelated.add(group);
      return this;
   }

   public UserQuery addRelatedGroup(String id)
   {
      checkNotNullArgument(id, "Group id");
      groupsRelated.add(createGroupFromId(id));
      return this;
   }

   public UserQuery addRelatedGroups(Collection<Group> group)
   {
      checkNotNullArgument(group, "Group");
      groupsRelated.addAll(group);
      return this;
   }

   public UserQuery addRelatedGroupsIds(Collection<String> ids)
   {
      checkNotNullArgument(ids, "Groups ids");
      for (String id : ids)
      {
         groupsRelated.add(createGroupFromId(id));
      }
      return this;
   }

   public UserQuery sort(SortOrder order) throws UnsupportedQueryCriterium
   {
      return (UserQuery)super.sort(order);
   }

   public UserQuery sortAttributeName(String name) throws UnsupportedQueryCriterium
   {
      return (UserQuery)super.sortAttributeName(name);
   }

   public UserQuery page(int firstResult, int maxResults) throws UnsupportedQueryCriterium
   {
      return (UserQuery)super.page(firstResult, maxResults);
   }

   public UserQuery attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedQueryCriterium
   {
      return (UserQuery)super.attributeValuesFilter(attributeName, attributeValue);
   }
}
