///*
//* JBoss, a division of Red Hat
//* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
//* by the @authors tag. See the copyright.txt in the distribution for a
//* full listing of individual contributors.
//*
//* This is free software; you can redistribute it and/or modify it
//* under the terms of the GNU Lesser General Public License as
//* published by the Free Software Foundation; either version 2.1 of
//* the License, or (at your option) any later version.
//*
//* This software is distributed in the hope that it will be useful,
//* but WITHOUT ANY WARRANTY; without even the implied warranty of
//* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
//* Lesser General Public License for more details.
//*
//* You should have received a copy of the GNU Lesser General Public
//* License along with this software; if not, write to the Free
//* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
//* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
//*/
//
//package org.jboss.identity.idm.impl.cache;
//
//import static org.jboss.identity.idm.impl.cache.CacheSupport.*;
//import org.jboss.identity.idm.impl.store.SimpleIdentityStoreInvocationContext;
//import org.jboss.identity.idm.impl.NotYetImplementedException;
//import org.jboss.identity.idm.impl.types.SimpleIdentityObjectType;
//import org.jboss.identity.idm.spi.store.IdentityStoreSession;
//import org.jboss.identity.idm.spi.store.IdentityStoreInvocationContext;
//import org.jboss.identity.idm.spi.store.IdentityStore;
//import org.jboss.identity.idm.spi.model.IdentityObjectType;
//import org.jboss.identity.idm.spi.model.IdentityObject;
//import org.jboss.identity.idm.spi.model.IdentityObjectAttribute;
//import org.jboss.identity.idm.exception.IdentityException;
//
//import org.jboss.cache.loader.CacheLoader;
//import org.jboss.cache.config.CacheLoaderConfig;
//import org.jboss.cache.CacheSPI;
//import org.jboss.cache.Fqn;
//import org.jboss.cache.RegionManager;
//import org.jboss.cache.Modification;
//import org.jboss.cache.Node;
//
//import java.util.Set;
//import java.util.Map;
//import java.util.List;
//import java.util.HashMap;
//import java.util.logging.Logger;
//import java.io.ObjectOutputStream;
//import java.io.ObjectInputStream;
//
///**
// * JBoss Cache CacheLoader implementation that wrapps IdentityStore. The main limitation is that
// * every IdentityStore method invocation needs IdentityStoreInvocation containing IdentityStoreSession and realm name.
// * Because of this CacheLoader needs to invoke IdentityStore.createIdentityStoreSession() method. It is fine for IdentityStore
// * implementations like LDAP with no real notion of session. For other session aware stores like Hibernate ones it can be
// * unacceptable. Therefore IdentityStoreCacheLoader should to be used wisely.
// *
// * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
// * @version : 0.1 $
// */
//public class IdentityStoreCacheLoader implements CacheLoader
//{
//   private static Logger log = Logger.getLogger(IdentityStoreCacheLoader.class.getName());
//
//   private CacheLoaderConfig.IndividualCacheLoaderConfig config;
//
//   private CacheSPI cacheSPI;
//
//   private IdentityStoreSession storeSession;
//
//   private String realmName;
//
//   private IdentityStore identityStore;
//
//   public IdentityStoreCacheLoader(String realmName, IdentityStore identityStore)
//   {
//      this.realmName = realmName;
//      this.identityStore = identityStore;
//   }
//
//   IdentityStoreInvocationContext getInvocationContext() throws IdentityException
//   {
//      if (storeSession == null || !storeSession.isOpen())
//      {
//         storeSession = identityStore.createIdentityStoreSession();
//      }
//
//      return new SimpleIdentityStoreInvocationContext(storeSession, realmName);
//   }
//
//
//   public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig individualCacheLoaderConfig)
//   {
//      config = individualCacheLoaderConfig;
//   }
//
//   public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig()
//   {
//      return config;
//   }
//
//   public void setCache(CacheSPI cacheSPI)
//   {
//      this.cacheSPI = cacheSPI;
//   }
//
//   public Set<?> getChildrenNames(Fqn fqn) throws Exception
//   {
//
//      throw new NotYetImplementedException("NYI");
//   }
//
//   public Map<Object, Object> get(Fqn fqn) throws Exception
//   {
//      Map<Object, Object> result = null;
//
//      if (isFqnObjectTypeIdsChild(fqn))
//      {
//         String ioId = fqn.getLastElementAsString();
//
//         IdentityObject io = identityStore.findIdentityObject(getInvocationContext(), ioId);
//
//         if (io != null)
//         {
//            result = new HashMap<Object, Object>();
//            result.put(NODE_OBJECT_KEY, io);
//         }
//      }
//      else if (isFqnObjectTypeNamesChild(fqn))
//      {
//         String ioName = fqn.getLastElementAsString();
//         IdentityObjectType ioType = new SimpleIdentityObjectType(fqn.getParent().getLastElementAsString());
//
//         IdentityObject io = identityStore.findIdentityObject(getInvocationContext(), ioName, ioType);
//
//         if (io != null)
//         {
//            result = new HashMap<Object, Object>();
//            result.put(NODE_OBJECT_KEY, io);
//         }
//      }
//      else if (isFqnObjectTypeProfilesChild(fqn))
//      {
//         String ioName = fqn.getLastElementAsString();
//         IdentityObjectType ioType = new SimpleIdentityObjectType(fqn.getParent().getLastElementAsString());
//
//         // Try to grab this IO from cache first
//         IdentityObject io = null;
//
//         Fqn nameCacheIOFqn = createIONameNodeFQN(ioType.getName(), ioName);
//
//         Node ioNode = cacheSPI.getRoot().getChild(nameCacheIOFqn);
//
//         if (ioNode != null)
//         {
//            io = (IdentityObject)ioNode.get(NODE_OBJECT_KEY);
//
//         }
//         else
//         {
//            io = identityStore.findIdentityObject(getInvocationContext(), ioName, ioType);
//
//            if (io != null)
//            {
//               // if object was not in cache put it there
//
//               ioNode = cacheSPI.getRoot().addChild(nameCacheIOFqn);
//
//               ioNode.put(NODE_OBJECT_KEY, io);
//            }
//         }
//
//         if (io != null)
//         {
//            Map<String, IdentityObjectAttribute> attributesMap = identityStore.getAttributes(getInvocationContext(), io);
//
//            result = new HashMap<Object, Object>();
//            result.put(NODE_ATTRIBUTES_KEY, attributesMap);
//         }
//      }
//      else
//      {
//         throw new NotYetImplementedException("NYI");
//      }
//
//      return result;
//   }
//
//   public boolean exists(Fqn fqn) throws Exception
//   {
//      if (isFqnObjectTypeIdsChild(fqn))
//      {
//         String ioId = fqn.getLastElementAsString();
//
//         IdentityObject io = identityStore.findIdentityObject(getInvocationContext(), ioId);
//
//         if (io != null)
//         {
//            return true;
//         }
//      }
//      else if (isFqnObjectTypeNamesChild(fqn))
//      {
//         String ioName = fqn.getLastElementAsString();
//         IdentityObjectType ioType = new SimpleIdentityObjectType(fqn.getParent().getLastElementAsString());
//
//         IdentityObject io = identityStore.findIdentityObject(getInvocationContext(), ioName, ioType);
//
//         if (io != null)
//         {
//            return true;
//         }
//      }
//      else if (isFqnObjectTypeProfilesChild(fqn))
//      {
//         String ioName = fqn.getLastElementAsString();
//         IdentityObjectType ioType = new SimpleIdentityObjectType(fqn.getParent().getLastElementAsString());
//
//         // Try to grab this IO from cache first
//         IdentityObject io = null;
//
//         Fqn nameCacheIOFqn = createIONameNodeFQN(ioType.getName(), ioName);
//
//         Node ioNode = cacheSPI.getRoot().getChild(nameCacheIOFqn);
//
//         if (ioNode != null)
//         {
//            return true;
//
//         }
//         else
//         {
//            io = identityStore.findIdentityObject(getInvocationContext(), ioName, ioType);
//
//            if (io != null)
//            {
//               return true;
//            }
//         }
//      }
//      else
//      {
//         throw new NotYetImplementedException("NYI");
//      }
//
//      return false;
//   }
//
//   public Object put(Fqn fqn, Object key, Object value) throws Exception
//   {
//      if (isFqnObjectTypeIdsChild(fqn) && key.toString().equals(NODE_OBJECT_KEY))
//      {
//         String ioId = fqn.getLastElementAsString();
//
//         IdentityObject io = identityStore.findIdentityObject(getInvocationContext(), ioId);
//
//         if (io != null)
//         {
//            result = new HashMap<Object, Object>();
//            result.put(NODE_OBJECT_KEY, io);
//         }
//      }
//      else if (isFqnObjectTypeNamesChild(fqn))
//      {
//         String ioName = fqn.getLastElementAsString();
//         IdentityObjectType ioType = new SimpleIdentityObjectType(fqn.getParent().getLastElementAsString());
//
//         IdentityObject io = identityStore.findIdentityObject(getInvocationContext(), ioName, ioType);
//
//         if (io != null)
//         {
//            result = new HashMap<Object, Object>();
//            result.put(NODE_OBJECT_KEY, io);
//         }
//      }
//      else if (isFqnObjectTypeProfilesChild(fqn))
//      {
//         String ioName = fqn.getLastElementAsString();
//         IdentityObjectType ioType = new SimpleIdentityObjectType(fqn.getParent().getLastElementAsString());
//
//         // Try to grab this IO from cache first
//         IdentityObject io = null;
//
//         Fqn nameCacheIOFqn = createIONameNodeFQN(ioType.getName(), ioName);
//
//         Node ioNode = cacheSPI.getRoot().getChild(nameCacheIOFqn);
//
//         if (ioNode != null)
//         {
//            io = (IdentityObject)ioNode.get(NODE_OBJECT_KEY);
//
//         }
//         else
//         {
//            io = identityStore.findIdentityObject(getInvocationContext(), ioName, ioType);
//
//            if (io != null)
//            {
//               // if object was not in cache put it there
//
//               ioNode = cacheSPI.getRoot().addChild(nameCacheIOFqn);
//
//               ioNode.put(NODE_OBJECT_KEY, io);
//            }
//         }
//
//         if (io != null)
//         {
//            Map<String, IdentityObjectAttribute> attributesMap = identityStore.getAttributes(getInvocationContext(), io);
//
//            result = new HashMap<Object, Object>();
//            result.put(NODE_ATTRIBUTES_KEY, attributesMap);
//         }
//      }
//      else
//      {
//         throw new NotYetImplementedException("NYI");
//      }
//
//   }
//
//   public void put(Fqn fqn, Map<Object, Object> objectObjectMap) throws Exception
//   {
//      throw new NotYetImplementedException("NYI");
//   }
//
//   public void put(List<Modification> modifications) throws Exception
//   {
//      if (modifications != null)
//      {
//         for (int i = 0; i < modifications.size(); ++i)
//         {
//
//            Modification m = modifications.get(i);
//
//            if (m.getType() == Modification.ModificationType.PUT_DATA)
//            {
//               put(m.getFqn(), m.getData());
//            }
//            else if (m.getType() == Modification.ModificationType.PUT_DATA_ERASE)
//            {
//               put(m.getFqn(), m.getData());
//            }
//            else if (m.getType() == Modification.ModificationType.PUT_KEY_VALUE)
//            {
//               put(m.getFqn(), m.getKey(), m.getValue());
//            }
//            else if (m.getType() == Modification.ModificationType.REMOVE_DATA)
//            {
//               removeData(m.getFqn());
//            }
//            else if (m.getType() == Modification.ModificationType.REMOVE_KEY_VALUE)
//            {
//               remove(m.getFqn(), m.getKey());
//            }
//            else if (m.getType() == Modification.ModificationType.REMOVE_NODE)
//            {
//               remove(m.getFqn());
//            }
//            else
//            {
//               throw new IllegalStateException("Unexpected modification code: " + m.getType());
//            }
//         }
//      }
//   }
//
//   public Object remove(Fqn fqn, Object o) throws Exception
//   {
//      throw new NotYetImplementedException("NYI");
//   }
//
//   public void remove(Fqn fqn) throws Exception
//   {
//      // For safety reasons remove is performed directly by IdentityStore call
//   }
//
//   public void removeData(Fqn fqn) throws Exception
//   {
//      throw new NotYetImplementedException("NYI");
//   }
//
//   // Transactions
//
//   public void prepare(Object o, List<Modification> modifications, boolean b) throws Exception
//   {
//      put(modifications);
//   }
//
//   public void commit(Object o) throws Exception
//   {
//      //
//   }
//
//   public void rollback(Object o)
//   {
//      //
//   }
//
//   public void loadEntireState(ObjectOutputStream objectOutputStream) throws Exception
//   {
//      //
//   }
//
//   public void storeEntireState(ObjectInputStream objectInputStream) throws Exception
//   {
//      //
//   }
//
//   public void loadState(Fqn fqn, ObjectOutputStream objectOutputStream) throws Exception
//   {
//      //
//   }
//
//   public void storeState(Fqn fqn, ObjectInputStream objectInputStream) throws Exception
//   {
//      //
//   }
//
//   public void setRegionManager(RegionManager regionManager)
//   {
//      //
//   }
//
//   public void create() throws Exception
//   {
//
//   }
//
//   public void start() throws Exception
//   {
//
//      // initialize cache structure for  nodes
//
//      cacheSPI.getRoot().addChild(Fqn.fromString(CacheSupport.JBID_ROOT_NODE)).setResident(true);
//      cacheSPI.getRoot().addChild(Fqn.fromString(CacheSupport.OBJECT_TYPES_NODE)).setResident(true);
//      cacheSPI.getRoot().addChild(FQN_OBJECT_TYPES_IDS).setResident(true);
//      cacheSPI.getRoot().addChild(FQN_OBJECT_TYPES_NAMES).setResident(true);
//      cacheSPI.getRoot().addChild(FQN_RELATIONSHIPS).setResident(true);
//
//      for (String objectTypeName : identityStore.getSupportedFeatures().getSupportedIdentityObjectTypes())
//      {
//         Fqn nodeFqn = Fqn.fromRelativeElements(FQN_OBJECT_TYPES_NAMES, "/" + objectTypeName);
//         cacheSPI.getRoot().addChild(nodeFqn).setResident(true);
//
//         nodeFqn = Fqn.fromRelativeElements(FQN_OBJECT_TYPES_IDS, "/" + objectTypeName);
//         cacheSPI.getRoot().addChild(nodeFqn).setResident(true);
//
//         nodeFqn = Fqn.fromRelativeElements(FQN_OBJECT_TYPES_PROFILES, "/" + objectTypeName);
//         cacheSPI.getRoot().addChild(nodeFqn).setResident(true);
//      }
//
//      for (String relationshipTypeName : identityStore.getSupportedFeatures().getSupportedRelationshipTypes())
//      {
//         Fqn nodeFqn = Fqn.fromRelativeElements(FQN_RELATIONSHIPS, "/" + relationshipTypeName);
//         cacheSPI.getRoot().addChild(nodeFqn).setResident(true);
//
//         nodeFqn = Fqn.fromRelativeElements(FQN_RELATIONSHIPS, "/" + relationshipTypeName, NAMED_SUBNODE);
//         cacheSPI.getRoot().addChild(nodeFqn).setResident(true);
//
//         nodeFqn = Fqn.fromRelativeElements(FQN_RELATIONSHIPS, "/" + relationshipTypeName, NOT_NAMED_SUBNODE);
//         cacheSPI.getRoot().addChild(nodeFqn).setResident(true);
//      }
//
//      log.fine("------------------------------------------------------");
//      log.fine("IdentityStoreCacheLoader successfully started....." +
//         "(Realm=" + this.realmName + "; IdentityStore: " + identityStore.getId() + ")");
//      log.fine("------------------------------------------------------");
//   }
//
//   public void stop()
//   {
//
//   }
//
//   public void destroy()
//   {
//
//   }
//}
