/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBInvocationHandler;
import org.jboss.ejb.client.EJBReceiver;

public final class EJBClientInvocationContext<A>
extends Attachable {
    private final EJBInvocationHandler invocationHandler;
    private final EJBClientContext ejbClientContext;
    private final A receiverSpecific;
    private final EJBReceiver<A> receiver;
    private final Object invokedProxy;
    private final Method invokedMethod;
    private Object[] parameters;
    private Callable<?> resultProducer;

    EJBClientInvocationContext(EJBInvocationHandler invocationHandler, EJBClientContext ejbClientContext, A receiverSpecific, EJBReceiver<A> receiver, Object invokedProxy, Method invokedMethod, Object[] parameters) {
        this.invocationHandler = invocationHandler;
        this.ejbClientContext = ejbClientContext;
        this.receiverSpecific = receiverSpecific;
        this.receiver = receiver;
        this.invokedProxy = invokedProxy;
        this.invokedMethod = invokedMethod;
        this.parameters = parameters;
    }

    public <T> T getProxyAttachment(AttachmentKey<T> key) {
        return this.invocationHandler.getAttachment(key);
    }

    public <T> T removeProxyAttachment(AttachmentKey<T> key) {
        return this.invocationHandler.removeAttachment(key);
    }

    public <T> T getClientContextAttachment(AttachmentKey<T> key) {
        return this.ejbClientContext.getAttachment(key);
    }

    public <T> T getReceiverAttachment(AttachmentKey<T> key) {
        return this.receiver.getAttachment(key);
    }

    public <T> T putReceiverAttachment(AttachmentKey<T> key, T value) {
        return this.receiver.putAttachment(key, value);
    }

    public String getAppName() {
        return this.invocationHandler.getAppName();
    }

    public String getModuleName() {
        return this.invocationHandler.getModuleName();
    }

    public String getDistinctName() {
        return this.invocationHandler.getDistinctName();
    }

    public String getBeanName() {
        return this.invocationHandler.getBeanName();
    }

    public A getReceiverSpecific() {
        return this.receiverSpecific;
    }

    public Object getResult() throws Exception {
        return this.resultProducer.call();
    }

    void resultReady(Callable<?> resultProducer) {
        this.resultProducer = resultProducer;
        try {
            Object result = this.getResult();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected EJBReceiver<A> getReceiver() {
        return this.receiver;
    }

    public Object getInvokedProxy() {
        return this.invokedProxy;
    }

    public Method getInvokedMethod() {
        return this.invokedMethod;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public Class<?> getViewClass() {
        return this.invocationHandler.getViewClass();
    }
}

