/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.Future;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.GeneralEJBClientInterceptor;

final class EJBInvocationHandler
extends Attachable
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 946555285095057230L;
    private final String appName;
    private final String moduleName;
    private final String distinctName;
    private final String beanName;
    private final Class<?> viewClass;
    private final transient boolean async;

    EJBInvocationHandler(Class<?> viewClass, String appName, String moduleName, String distinctName, String beanName) {
        this.viewClass = viewClass;
        this.appName = appName;
        this.moduleName = moduleName;
        this.distinctName = distinctName;
        this.beanName = beanName;
        this.async = false;
    }

    private EJBInvocationHandler(EJBInvocationHandler twin) {
        super(twin);
        this.viewClass = twin.viewClass;
        this.appName = twin.appName;
        this.moduleName = twin.moduleName;
        this.distinctName = twin.distinctName;
        this.beanName = twin.beanName;
        this.async = true;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        EJBClientContext context = EJBClientContext.requireCurrent();
        EJBReceiver<?> receiver = context.requireEJBReceiver(this.appName, this.moduleName, this.distinctName);
        return this.doInvoke(proxy, method, args, receiver, context);
    }

    private <A> Object doInvoke(Object proxy, Method method, Object[] args, EJBReceiver<A> receiver, EJBClientContext clientContext) throws Throwable {
        EJBClientInvocationContext<A> invocationContext = new EJBClientInvocationContext<A>(this, clientContext, receiver.createReceiverSpecific(), receiver, proxy, method, args);
        for (GeneralEJBClientInterceptor interceptor : EJBClientContext.GENERAL_INTERCEPTORS) {
            interceptor.handleInvocation(invocationContext);
        }
        EJBReceiverContext ejbReceiverContext = clientContext.requireEJBReceiverContext(receiver);
        if (this.async) {
            if (method.getReturnType() == Future.class) {
                return receiver.processInvocation(invocationContext, ejbReceiverContext);
            }
            if (method.getReturnType() == Void.TYPE) {
                receiver.processInvocation(invocationContext, ejbReceiverContext);
                return null;
            }
            EJBClient.setFutureResult(receiver.processInvocation(invocationContext, ejbReceiverContext));
            return null;
        }
        return receiver.processInvocation(invocationContext, ejbReceiverContext).get();
    }

    public String getAppName() {
        return this.appName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getDistinctName() {
        return this.distinctName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public Class<?> getViewClass() {
        return this.viewClass;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.async) {
            throw new NotSerializableException("Async proxies are not serializable");
        }
        oos.defaultWriteObject();
    }

    EJBInvocationHandler getAsyncHandler() {
        return this.async ? this : new EJBInvocationHandler(this);
    }
}

