/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.ejb.client.remoting.RemotingAttachments;
import org.jboss.ejb.client.remoting.ResponseReceiver;
import org.jboss.ejb.client.remoting.VersionReceiver;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public final class RemotingConnectionEJBReceiver
extends EJBReceiver<RemotingAttachments> {
    private static final Logger logger = Logger.getLogger(RemotingConnectionEJBReceiver.class);
    private final Connection connection;
    private final Map<EJBReceiverContext, Channel> perReceiverContextChannels = new IdentityHashMap<EJBReceiverContext, Channel>();
    private final byte clientProtocolVersion = 0;
    private final String clientMarshallingStrategy = "river";

    public RemotingConnectionEJBReceiver(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void associate(EJBReceiverContext context) {
        IoFuture futureChannel = this.connection.openChannel("jboss.ejb", OptionMap.EMPTY);
        futureChannel.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<Channel, EJBReceiverContext>(){

            public void handleCancelled(EJBReceiverContext context) {
                context.close();
            }

            public void handleFailed(IOException exception, EJBReceiverContext context) {
                context.close();
            }

            public void handleDone(Channel channel, final EJBReceiverContext context) {
                channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                    public void handleClose(Channel closed, IOException exception) {
                        context.close();
                    }
                });
                channel.receiveMessage((Channel.Receiver)new VersionReceiver(RemotingConnectionEJBReceiver.this, context, 0, "river"));
            }
        }, (Object)context);
    }

    @Override
    public Future<?> processInvocation(EJBClientInvocationContext<RemotingAttachments> clientInvocationContext, EJBReceiverContext ejbReceiverContext) throws Exception {
        FutureResult futureResult = new FutureResult();
        futureResult.setResult(null);
        return IoFutureHelper.future(futureResult.getIoFuture());
    }

    @Override
    public byte[] openSession(EJBReceiverContext receiverContext, String appName, String moduleName, String distinctName, String beanName) throws Exception {
        return new byte[0];
    }

    @Override
    public void verify(String appName, String moduleName, String distinctName, String beanName) throws Exception {
    }

    @Override
    public RemotingAttachments createReceiverSpecific() {
        return new RemotingAttachments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSuccessfulVersionHandshake(EJBReceiverContext receiverContext, Channel channel) {
        Map<EJBReceiverContext, Channel> map = this.perReceiverContextChannels;
        synchronized (map) {
            this.perReceiverContextChannels.put(receiverContext, channel);
        }
        channel.receiveMessage((Channel.Receiver)new ResponseReceiver(this, receiverContext));
    }

    ProtocolMessageHandler getProtocolMessageHandler(EJBReceiverContext ejbReceiverContext, byte header) {
        return null;
    }
}

