/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.logging.Logger;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.SimpleDataInput;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;

class VersionReceiver
implements Channel.Receiver {
    private static final Logger logger = Logger.getLogger(VersionReceiver.class);
    private final EJBReceiverContext receiverContext;
    private final RemotingConnectionEJBReceiver ejbReceiver;
    private final byte clientVersion;
    private final String clientMarshallingStrategy;

    VersionReceiver(RemotingConnectionEJBReceiver ejbReceiver, EJBReceiverContext receiverContext, byte clientVersion, String marshallingStrategy) {
        this.ejbReceiver = ejbReceiver;
        this.receiverContext = receiverContext;
        this.clientVersion = clientVersion;
        this.clientMarshallingStrategy = marshallingStrategy;
    }

    public void handleError(Channel channel, IOException error) {
    }

    public void handleEnd(Channel channel) {
    }

    public void handleMessage(Channel channel, MessageInputStream message) {
        String[] serverMarshallerStrategies;
        byte serverVersion;
        SimpleDataInput simpleDataInput = new SimpleDataInput(Marshalling.createByteInput((InputStream)message));
        try {
            serverVersion = simpleDataInput.readByte();
            int serverMarshallerCount = PackedInteger.readPackedInteger((DataInput)simpleDataInput);
            if (serverMarshallerCount <= 0) {
                // empty if block
            }
            serverMarshallerStrategies = new String[serverMarshallerCount];
            logger.info((Object)("Received server version " + serverVersion + " and marshalling strategies " + serverMarshallerStrategies));
            for (int i = 0; i < serverMarshallerCount; ++i) {
                serverMarshallerStrategies[i] = simpleDataInput.readUTF();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!this.checkCompatibility(serverVersion, serverMarshallerStrategies)) {
            logger.error((Object)"EJB receiver cannot communicate with server, due to version incompatibility");
            this.receiverContext.close();
            return;
        }
        try {
            this.sendVersionMessage(channel);
            this.ejbReceiver.onSuccessfulVersionHandshake(this.receiverContext, channel);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private boolean checkCompatibility(byte serverVersion, String[] serverMarshallingStrategies) {
        if (serverVersion < this.clientVersion) {
            return false;
        }
        List<String> supportedStrategies = Arrays.asList(serverMarshallingStrategies);
        return supportedStrategies.contains(this.clientMarshallingStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendVersionMessage(Channel channel) throws IOException {
        MessageOutputStream channelOutputStream = channel.writeMessage();
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channelOutputStream);
        try {
            dataOutputStream.write(this.clientVersion);
            dataOutputStream.writeUTF(this.clientMarshallingStrategy);
        }
        finally {
            dataOutputStream.close();
            channelOutputStream.close();
        }
    }
}

