/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBInvocationHandler;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.Logs;

public final class EJBClientInvocationContext
extends Attachable {
    private static final Logs log = Logs.MAIN;
    private final EJBReceiverInvocationContext receiverInvocationContext;
    private final EJBInvocationHandler<?> invocationHandler;
    private final EJBClientContext ejbClientContext;
    private final EJBReceiver receiver;
    private final Object invokedProxy;
    private final Method invokedMethod;
    private final Object[] parameters;
    private final Object lock = new Object();
    private EJBReceiverInvocationContext.ResultProducer resultProducer;
    private State state = State.WAITING;
    private AsyncState asyncState = AsyncState.SYNCHRONOUS;
    private Object cachedResult;
    private Map<String, Object> contextData;
    private final EJBClientInterceptor[] interceptorChain;
    private int idx;
    private boolean requestDone;
    private boolean resultDone;
    static final Object PROCEED_ASYNC = new Object();

    EJBClientInvocationContext(EJBInvocationHandler<?> invocationHandler, EJBClientContext ejbClientContext, EJBReceiver receiver, EJBReceiverContext ejbReceiverContext, Object invokedProxy, Method invokedMethod, Object[] parameters) {
        this.invocationHandler = invocationHandler;
        this.ejbClientContext = ejbClientContext;
        this.receiver = receiver;
        this.invokedProxy = invokedProxy;
        this.invokedMethod = invokedMethod;
        this.parameters = parameters;
        this.interceptorChain = ejbClientContext.getInterceptorChain();
        this.receiverInvocationContext = new EJBReceiverInvocationContext(this, ejbReceiverContext);
    }

    public <T> T getProxyAttachment(AttachmentKey<T> key) {
        return this.invocationHandler.getAttachment(key);
    }

    public <T> T removeProxyAttachment(AttachmentKey<T> key) {
        return this.invocationHandler.removeAttachment(key);
    }

    public <T> T getClientContextAttachment(AttachmentKey<T> key) {
        return this.ejbClientContext.getAttachment(key);
    }

    public <T> T getReceiverAttachment(AttachmentKey<T> key) {
        return this.receiver.getAttachment(key);
    }

    public <T> T putReceiverAttachment(AttachmentKey<T> key, T value) {
        return this.receiver.putAttachment(key, value);
    }

    public Map<String, Object> getContextData() {
        if (this.contextData == null) {
            this.contextData = new LinkedHashMap<String, Object>();
            return this.contextData;
        }
        return this.contextData;
    }

    public EJBLocator<?> getLocator() {
        return this.invocationHandler.getLocator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest() throws Exception {
        if (this.requestDone) {
            throw new IllegalStateException("sendRequest() called during wrong phase");
        }
        int idx = this.idx++;
        EJBClientInterceptor[] chain = this.interceptorChain;
        try {
            if (chain.length == idx) {
                this.receiver.processInvocation(this, this.receiverInvocationContext);
            } else {
                chain[idx].handleInvocation(this);
            }
        }
        finally {
            this.requestDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResult() throws Exception {
        EJBReceiverInvocationContext.ResultProducer resultProducer = this.resultProducer;
        if (this.resultDone || resultProducer == null) {
            throw new IllegalStateException("getResult() called during wrong phase");
        }
        int idx = this.idx++;
        EJBClientInterceptor[] chain = this.interceptorChain;
        try {
            if (chain.length == idx) {
                Object object = resultProducer.getResult();
                return object;
            }
            Object object = chain[idx].handleInvocationResult(this);
            return object;
        }
        finally {
            this.resultDone = true;
        }
    }

    public void discardResult() throws IllegalStateException {
        EJBReceiverInvocationContext.ResultProducer resultProducer = this.resultProducer;
        if (resultProducer == null) {
            throw new IllegalStateException("discardResult() called during request phase");
        }
        resultProducer.discardResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resultReady(EJBReceiverInvocationContext.ResultProducer resultProducer) {
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case WAITING: 
                case CANCEL_REQ: {
                    this.resultProducer = resultProducer;
                    this.idx = 0;
                    this.state = State.READY;
                    this.lock.notifyAll();
                    return;
                }
            }
        }
        resultProducer.discardResult();
    }

    protected EJBReceiver getReceiver() {
        return this.receiver;
    }

    public Object getInvokedProxy() {
        return this.invokedProxy;
    }

    public Method getInvokedMethod() {
        return this.invokedMethod;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public Class<?> getViewClass() {
        return this.invocationHandler.getLocator().getViewType();
    }

    Future<?> getFutureResponse() {
        return new FutureResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void proceedAsynchronously() {
        assert (!Thread.holdsLock(this.lock));
        Object object = this.lock;
        synchronized (object) {
            if (this.asyncState == AsyncState.SYNCHRONOUS) {
                this.asyncState = AsyncState.ASYNCHRONOUS;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * Exception decompiling
     */
    Object awaitResponse() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDiscardResult() {
        EJBReceiverInvocationContext.ResultProducer resultProducer;
        assert (!Thread.holdsLock(this.lock));
        Object object = this.lock;
        synchronized (object) {
            if (this.asyncState != AsyncState.ONE_WAY) {
                this.asyncState = AsyncState.ONE_WAY;
                this.notifyAll();
            }
            if (this.state != State.DONE) {
                return;
            }
            this.state = State.DISCARDED;
            resultProducer = this.resultProducer;
            this.notifyAll();
        }
        resultProducer.discardResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelled() {
        assert (!Thread.holdsLock(this.lock));
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case WAITING: 
                case CANCEL_REQ: {
                    this.state = State.CANCELLED;
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failed(Throwable exception) {
        assert (!Thread.holdsLock(this.lock));
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case WAITING: 
                case CANCEL_REQ: {
                    this.state = State.FAILED;
                    this.cachedResult = exception;
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        EJBReceiverInvocationContext.ResultProducer resultProducer;
        assert (!Thread.holdsLock(this.lock));
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case WAITING: 
                case CANCEL_REQ: {
                    return;
                }
                case READY: {
                    resultProducer = this.resultProducer;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        resultProducer.discardResult();
    }

    final class FutureResponse
    implements Future<Object> {
        FutureResponse() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            assert (!Thread.holdsLock(EJBClientInvocationContext.this.lock));
            Object object = EJBClientInvocationContext.this.lock;
            synchronized (object) {
                if (EJBClientInvocationContext.this.state != State.WAITING) {
                    return false;
                }
                EJBClientInvocationContext.this.state = State.CANCEL_REQ;
            }
            return EJBClientInvocationContext.this.receiver.cancelInvocation(EJBClientInvocationContext.this, EJBClientInvocationContext.this.receiverInvocationContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            assert (!Thread.holdsLock(EJBClientInvocationContext.this.lock));
            Object object = EJBClientInvocationContext.this.lock;
            synchronized (object) {
                return EJBClientInvocationContext.this.state == State.CANCELLED;
            }
        }

        @Override
        public boolean isDone() {
            assert (!Thread.holdsLock(EJBClientInvocationContext.this.lock));
            Object object = EJBClientInvocationContext.this.lock;
            synchronized (object) {
                switch (EJBClientInvocationContext.this.state) {
                    case WAITING: 
                    case CANCEL_REQ: {
                        return false;
                    }
                    case READY: 
                    case FAILED: 
                    case CANCELLED: 
                    case DONE: 
                    case CONSUMING: 
                    case DISCARDED: {
                        return true;
                    }
                }
                throw new IllegalStateException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get() throws InterruptedException, ExecutionException {
            Object result;
            EJBReceiverInvocationContext.ResultProducer resultProducer;
            assert (!Thread.holdsLock(EJBClientInvocationContext.this.lock));
            Object object = EJBClientInvocationContext.this.lock;
            synchronized (object) {
                while (EJBClientInvocationContext.this.state == State.WAITING || EJBClientInvocationContext.this.state == State.CANCEL_REQ || EJBClientInvocationContext.this.state == State.CONSUMING) {
                    EJBClientInvocationContext.this.lock.wait();
                }
                switch (EJBClientInvocationContext.this.state) {
                    case READY: {
                        EJBClientInvocationContext.this.state = State.CONSUMING;
                        resultProducer = EJBClientInvocationContext.this.resultProducer;
                        break;
                    }
                    case FAILED: {
                        throw log.remoteInvFailed((Throwable)EJBClientInvocationContext.this.cachedResult);
                    }
                    case CANCELLED: {
                        throw log.requestCancelled();
                    }
                    case DONE: {
                        return EJBClientInvocationContext.this.cachedResult;
                    }
                    case DISCARDED: {
                        throw log.oneWayInvocation();
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            try {
                result = resultProducer.getResult();
            }
            catch (Exception e) {
                Object object2 = EJBClientInvocationContext.this.lock;
                synchronized (object2) {
                    assert (EJBClientInvocationContext.this.state == State.CONSUMING);
                    EJBClientInvocationContext.this.state = State.FAILED;
                    EJBClientInvocationContext.this.cachedResult = e;
                    EJBClientInvocationContext.this.lock.notifyAll();
                }
                throw log.remoteInvFailed(e);
            }
            Object object3 = EJBClientInvocationContext.this.lock;
            synchronized (object3) {
                assert (EJBClientInvocationContext.this.state == State.CONSUMING);
                EJBClientInvocationContext.this.state = State.DONE;
                EJBClientInvocationContext.this.cachedResult = result;
                EJBClientInvocationContext.this.lock.notifyAll();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Object result;
            EJBReceiverInvocationContext.ResultProducer resultProducer;
            assert (!Thread.holdsLock(EJBClientInvocationContext.this.lock));
            Object object = EJBClientInvocationContext.this.lock;
            synchronized (object) {
                if (EJBClientInvocationContext.this.state == State.WAITING || EJBClientInvocationContext.this.state == State.CANCEL_REQ || EJBClientInvocationContext.this.state == State.CONSUMING) {
                    long now = System.nanoTime();
                    long end = Math.max(now, now + unit.toNanos(timeout));
                    do {
                        long remaining;
                        if ((remaining = end - now) <= 0L) {
                            throw log.timedOut();
                        }
                        long millis = (remaining + 999999L) / 1000000L;
                        this.wait(millis);
                        now = System.nanoTime();
                    } while (EJBClientInvocationContext.this.state == State.WAITING || EJBClientInvocationContext.this.state == State.CANCEL_REQ || EJBClientInvocationContext.this.state == State.CONSUMING);
                }
                switch (EJBClientInvocationContext.this.state) {
                    case READY: {
                        EJBClientInvocationContext.this.state = State.CONSUMING;
                        resultProducer = EJBClientInvocationContext.this.resultProducer;
                        break;
                    }
                    case FAILED: {
                        throw log.remoteInvFailed((Throwable)EJBClientInvocationContext.this.cachedResult);
                    }
                    case CANCELLED: {
                        throw log.requestCancelled();
                    }
                    case DONE: {
                        return EJBClientInvocationContext.this.cachedResult;
                    }
                    case DISCARDED: {
                        throw log.oneWayInvocation();
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            try {
                result = resultProducer.getResult();
            }
            catch (Exception e) {
                Object object2 = EJBClientInvocationContext.this.lock;
                synchronized (object2) {
                    assert (EJBClientInvocationContext.this.state == State.CONSUMING);
                    EJBClientInvocationContext.this.state = State.FAILED;
                    EJBClientInvocationContext.this.cachedResult = e;
                    EJBClientInvocationContext.this.lock.notifyAll();
                }
                throw log.remoteInvFailed(e);
            }
            Object object3 = EJBClientInvocationContext.this.lock;
            synchronized (object3) {
                assert (EJBClientInvocationContext.this.state == State.CONSUMING);
                EJBClientInvocationContext.this.state = State.DONE;
                EJBClientInvocationContext.this.cachedResult = result;
                EJBClientInvocationContext.this.lock.notifyAll();
            }
            return result;
        }
    }

    static enum State {
        WAITING,
        CANCEL_REQ,
        CANCELLED,
        READY,
        CONSUMING,
        FAILED,
        DONE,
        DISCARDED;

    }

    static enum AsyncState {
        SYNCHRONOUS,
        ASYNCHRONOUS,
        ONE_WAY;

    }
}

