/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.jboss.ejb.client.TransactionID;

public final class XidTransactionID
extends TransactionID {
    private static final long serialVersionUID = -1895745528459825578L;
    private final int formatId;
    private final byte gtidLen;
    private final Xid xid = new XidImpl();

    XidTransactionID(byte[] encodedBytes) {
        super(encodedBytes);
        this.formatId = (encodedBytes[1] & 0xFF) << 24 | (encodedBytes[2] & 0xFF) << 16 | (encodedBytes[3] & 0xFF) << 8 | encodedBytes[4] & 0xFF;
        this.gtidLen = encodedBytes[5];
        if (this.gtidLen > 64) {
            throw new IllegalArgumentException("Invalid global transaction ID length");
        }
        byte bqalLen = encodedBytes[6 + this.gtidLen];
        if (bqalLen > 64 || bqalLen != encodedBytes.length - this.gtidLen - 6) {
            throw new IllegalArgumentException("Invalid branch qualifier length");
        }
    }

    XidTransactionID(Xid original) {
        this(XidTransactionID.encode(original));
    }

    private static byte[] encode(Xid original) {
        byte[] gtid = original.getGlobalTransactionId();
        byte[] bqal = original.getBranchQualifier();
        int formatId = original.getFormatId();
        byte[] target = new byte[gtid.length + bqal.length + 6];
        target[0] = (byte)(formatId >>> 24);
        target[1] = (byte)(formatId >>> 16);
        target[2] = (byte)(formatId >>> 8);
        target[3] = (byte)formatId;
        target[4] = (byte)gtid.length;
        System.arraycopy(gtid, 0, target, 5, gtid.length);
        target[6 + gtid.length] = (byte)bqal.length;
        System.arraycopy(bqal, 0, target, 7 + gtid.length, bqal.length);
        return target;
    }

    public Xid getXid() {
        return this.xid;
    }

    public boolean isSameXid(Xid xid) {
        return this.xid.equals(xid);
    }

    final class XidImpl
    implements Xid {
        XidImpl() {
        }

        @Override
        public int getFormatId() {
            return XidTransactionID.this.formatId;
        }

        @Override
        public byte[] getGlobalTransactionId() {
            byte[] target = new byte[XidTransactionID.this.gtidLen];
            System.arraycopy(XidTransactionID.this.getEncodedFormRaw(), 6, target, 0, XidTransactionID.this.gtidLen);
            return target;
        }

        @Override
        public byte[] getBranchQualifier() {
            byte[] raw = XidTransactionID.this.getEncodedFormRaw();
            byte[] target = new byte[raw.length - XidTransactionID.this.gtidLen - 6];
            System.arraycopy(raw, 6, target, 0, XidTransactionID.this.gtidLen);
            return target;
        }

        public boolean equals(Object other) {
            return other instanceof XidImpl && this.equals((XidImpl)other) || other instanceof Xid && this.equals((Xid)other);
        }

        private boolean equals(XidImpl other) {
            return this == other || other != null && XidTransactionID.this.equals(other.getXidTransactionID());
        }

        private boolean equals(Xid other) {
            return other != null && Arrays.equals(XidTransactionID.encode(other), XidTransactionID.this.getEncodedFormRaw());
        }

        public int hashCode() {
            return XidTransactionID.this.hashCode();
        }

        XidTransactionID getXidTransactionID() {
            return XidTransactionID.this;
        }
    }
}

