/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.remoting.ChannelAssociation;
import org.jboss.ejb.client.remoting.MarshallerFactory;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.ejb.client.remoting.UnMarshaller;
import org.jboss.logging.Logger;
import org.jboss.remoting3.MessageInputStream;

class MethodInvocationResponseHandler
extends ProtocolMessageHandler {
    private static final Logger logger = Logger.getLogger(MethodInvocationResponseHandler.class);
    private final String marshallingType;
    private final ChannelAssociation channelAssociation;

    MethodInvocationResponseHandler(ChannelAssociation channelAssociation, String marshallingType) {
        this.marshallingType = marshallingType;
        this.channelAssociation = channelAssociation;
    }

    @Override
    protected void processMessage(MessageInputStream messageInputStream) throws IOException {
        if (messageInputStream == null) {
            throw new IllegalArgumentException("Cannot read from null stream");
        }
        DataInputStream input = new DataInputStream((InputStream)messageInputStream);
        short invocationId = input.readShort();
        MethodInvocationResultProducer resultProducer = new MethodInvocationResultProducer(input);
        this.channelAssociation.resultReady(invocationId, resultProducer);
    }

    private class MethodInvocationResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final DataInputStream input;

        MethodInvocationResultProducer(DataInputStream input) {
            this.input = input;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getResult() throws Exception {
            try {
                MethodInvocationResponseHandler.this.readAttachments(this.input);
                UnMarshaller unMarshaller = MarshallerFactory.createUnMarshaller(MethodInvocationResponseHandler.this.marshallingType);
                final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                UnMarshaller.ClassLoaderProvider classLoaderProvider = new UnMarshaller.ClassLoaderProvider(){

                    @Override
                    public ClassLoader provideClassLoader() {
                        return classLoader;
                    }
                };
                unMarshaller.start(this.input, classLoaderProvider);
                Object result = unMarshaller.readObject();
                unMarshaller.finish();
                Object object = result;
                return object;
            }
            finally {
                this.input.close();
            }
        }

        @Override
        public void discardResult() {
        }
    }
}

