/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Map;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.ejb.client.remoting.ProtocolV1ClassTable;
import org.jboss.ejb.client.remoting.ProtocolV1ObjectTable;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.reflect.SunReflectiveCreator;

class AbstractMessageWriter {
    AbstractMessageWriter() {
    }

    protected void writeAttachments(ObjectOutput output, EJBClientInvocationContext invocationContext) throws IOException {
        Map privateAttachments = invocationContext.getAttachments();
        Map<String, Object> contextData = invocationContext.getContextData();
        if (contextData == null && privateAttachments.isEmpty()) {
            output.writeByte(0);
            return;
        }
        int totalAttachments = contextData.size();
        if (!privateAttachments.isEmpty()) {
            ++totalAttachments;
        }
        PackedInteger.writePackedInteger(output, totalAttachments);
        for (Map.Entry<String, Object> invocationContextData : contextData.entrySet()) {
            output.writeObject(invocationContextData.getKey());
            output.writeObject(invocationContextData.getValue());
        }
        if (!privateAttachments.isEmpty()) {
            output.writeObject("org.jboss.ejb.client.invocation.attachments");
            output.writeObject(privateAttachments);
        }
    }

    protected Marshaller prepareForMarshalling(MarshallerFactory marshallerFactory, final DataOutput dataOutput) throws IOException {
        Marshaller marshaller = this.getMarshaller(marshallerFactory);
        OutputStream outputStream = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                int byteToWrite = b & 0xFF;
                dataOutput.write(byteToWrite);
            }
        };
        ByteOutput byteOutput = Marshalling.createByteOutput((OutputStream)outputStream);
        marshaller.start(byteOutput);
        return marshaller;
    }

    private Marshaller getMarshaller(MarshallerFactory marshallerFactory) throws IOException {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setClassTable((ClassTable)ProtocolV1ClassTable.INSTANCE);
        marshallingConfiguration.setObjectTable((ObjectTable)ProtocolV1ObjectTable.INSTANCE);
        marshallingConfiguration.setVersion(2);
        marshallingConfiguration.setSerializedCreator((Creator)new SunReflectiveCreator());
        return marshallerFactory.createMarshaller(marshallingConfiguration);
    }
}

