/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.ConfigurationBasedEJBClientContextSelector;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBTransportProvider;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.client.URIAffinity;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.discovery.Discovery;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceType;
import org.wildfly.discovery.ServicesQueue;

public final class EJBClientContext
extends Attachable
implements Contextual<EJBClientContext> {
    public static final ServiceType EJB_SERVICE_TYPE = ServiceType.of((String)"ejb", (String)"jboss");
    private static final ContextManager<EJBClientContext> CONTEXT_MANAGER = new ContextManager(EJBClientContext.class, "jboss.ejb.client");
    private static final Supplier<Discovery> DISCOVERY_SUPPLIER = AccessController.doPrivileged(() -> ((ContextManager)Discovery.getContextManager()).getPrivilegedSupplier());
    static final Supplier<EJBClientContext> GETTER = AccessController.doPrivileged(() -> CONTEXT_MANAGER.getPrivilegedSupplier());
    private static final EJBClientInterceptor[] NO_INTERCEPTORS = new EJBClientInterceptor[0];
    private static final EJBTransportProvider[] NO_TRANSPORT_PROVIDERS = new EJBTransportProvider[0];
    static final String FILTER_ATTR_EJB_APP = "ejb-app";
    static final String FILTER_ATTR_EJB_MODULE = "ejb-module";
    static final String FILTER_ATTR_EJB_BEAN = "ejb-bean";
    static final String FILTER_ATTR_EJB_DISTINCT = "ejb-distinct";
    static final String FILTER_ATTR_EJB_APP_DISTINCT = "ejb-app-distinct";
    static final String FILTER_ATTR_EJB_MODULE_DISTINCT = "ejb-module-distinct";
    static final String FILTER_ATTR_EJB_BEAN_DISTINCT = "ejb-bean-distinct";
    private final EJBClientInterceptor[] interceptors;
    private final EJBTransportProvider[] transportProviders;
    private final long invocationTimeout;

    EJBClientContext(Builder builder) {
        List<EJBClientInterceptor> builderInterceptors = builder.interceptors;
        this.interceptors = builderInterceptors == null || builderInterceptors.isEmpty() ? NO_INTERCEPTORS : builderInterceptors.toArray(new EJBClientInterceptor[builderInterceptors.size()]);
        List<EJBTransportProvider> builderTransportProviders = builder.transportProviders;
        this.transportProviders = builderTransportProviders == null || builderTransportProviders.isEmpty() ? NO_TRANSPORT_PROVIDERS : builderTransportProviders.toArray(new EJBTransportProvider[builderTransportProviders.size()]);
        this.invocationTimeout = 0L;
    }

    public ContextManager<EJBClientContext> getInstanceContextManager() {
        return EJBClientContext.getContextManager();
    }

    public static ContextManager<EJBClientContext> getContextManager() {
        return CONTEXT_MANAGER;
    }

    public long getInvocationTimeout() {
        return this.invocationTimeout;
    }

    public EJBClientContext withAddedInterceptors(EJBClientInterceptor ... interceptors) {
        if (interceptors == null) {
            return this;
        }
        int length = interceptors.length;
        if (length == 0) {
            return this;
        }
        Builder builder = new Builder(this);
        boolean construct = false;
        for (EJBClientInterceptor interceptor : interceptors) {
            if (interceptor == null) continue;
            builder.addInterceptor(interceptor);
            construct = true;
        }
        return construct ? builder.build() : this;
    }

    public EJBClientContext withAddedTransportProviders(EJBTransportProvider ... transportProviders) {
        if (transportProviders == null) {
            return this;
        }
        int length = transportProviders.length;
        if (length == 0) {
            return this;
        }
        Builder builder = new Builder(this);
        boolean construct = false;
        for (EJBTransportProvider transportProvider : transportProviders) {
            if (transportProvider == null) continue;
            builder.addTransportProvider(transportProvider);
            construct = true;
        }
        return construct ? builder.build() : this;
    }

    EJBReceiver getTransportProvider(String scheme) {
        for (EJBTransportProvider transportProvider : this.transportProviders) {
            if (!transportProvider.supportsProtocol(scheme)) continue;
            return transportProvider.getReceiver(scheme);
        }
        return null;
    }

    ServicesQueue discover(FilterSpec filterSpec) {
        return this.getDiscovery().discover(EJB_SERVICE_TYPE, filterSpec);
    }

    EJBTransportProvider[] getTransportProviders() {
        return this.transportProviders;
    }

    Discovery getDiscovery() {
        return DISCOVERY_SUPPLIER.get();
    }

    public static EJBClientContext getCurrent() {
        return GETTER.get();
    }

    public static EJBClientContext requireCurrent() throws IllegalStateException {
        EJBClientContext clientContext = EJBClientContext.getCurrent();
        if (clientContext == null) {
            throw Logs.MAIN.noEJBClientContextAvailable();
        }
        return clientContext;
    }

    <T> StatefulEJBLocator<T> createSession(StatelessEJBLocator<T> statelessLocator) throws Exception {
        LocatedAction action = (receiver, originalLocator, newAffinity) -> receiver.createSession(originalLocator.withNewAffinity(newAffinity));
        return this.performLocatedAction(statelessLocator, action);
    }

    <R, L extends EJBLocator<T>, T> R performLocatedAction(L locator, LocatedAction<R, L, T> locatedAction) throws Exception {
        String scheme;
        Affinity affinity = locator.getAffinity();
        if (affinity instanceof NodeAffinity) {
            return this.discoverFirst(locator, locatedAction);
        }
        if (affinity instanceof ClusterAffinity) {
            return this.discoverFirst(locator, locatedAction);
        }
        if (affinity == Affinity.LOCAL) {
            scheme = "local";
        } else if (affinity instanceof URIAffinity) {
            scheme = ((URIAffinity)affinity).getUri().getScheme();
        } else {
            assert (affinity == Affinity.NONE);
            return this.discoverFirst(locator, locatedAction);
        }
        EJBReceiver transportProvider = this.getTransportProvider(scheme);
        if (transportProvider == null) {
            throw Logs.MAIN.noEJBReceiverAvailable(locator);
        }
        return locatedAction.execute(transportProvider, locator, locator.getAffinity());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <R, L extends EJBLocator<T>, T> R discoverFirst(L locator, LocatedAction<R, L, T> locatedAction) throws Exception {
        FilterSpec filterSpec;
        Affinity affinity = locator.getAffinity();
        if (affinity == Affinity.NONE) {
            String appName = locator.getAppName();
            String moduleName = locator.getModuleName();
            String beanName = locator.getBeanName();
            String distinctName = locator.getDistinctName();
            filterSpec = distinctName != null && !distinctName.isEmpty() ? FilterSpec.any((FilterSpec[])new FilterSpec[]{FilterSpec.equal((String)FILTER_ATTR_EJB_APP, (String)appName), FilterSpec.equal((String)FILTER_ATTR_EJB_MODULE, (String)(appName + '/' + moduleName)), FilterSpec.equal((String)FILTER_ATTR_EJB_BEAN, (String)(appName + '/' + moduleName + '/' + beanName)), FilterSpec.equal((String)FILTER_ATTR_EJB_DISTINCT, (String)distinctName), FilterSpec.equal((String)FILTER_ATTR_EJB_APP_DISTINCT, (String)(appName + '/' + distinctName)), FilterSpec.equal((String)FILTER_ATTR_EJB_MODULE_DISTINCT, (String)(appName + '/' + moduleName + '/' + distinctName)), FilterSpec.equal((String)FILTER_ATTR_EJB_BEAN_DISTINCT, (String)(appName + '/' + moduleName + '/' + beanName + '/' + distinctName))}) : FilterSpec.any((FilterSpec[])new FilterSpec[]{FilterSpec.equal((String)FILTER_ATTR_EJB_APP, (String)appName), FilterSpec.equal((String)FILTER_ATTR_EJB_MODULE, (String)(appName + '/' + moduleName)), FilterSpec.equal((String)FILTER_ATTR_EJB_BEAN, (String)(appName + '/' + moduleName + '/' + beanName))});
        } else if (affinity instanceof NodeAffinity) {
            filterSpec = FilterSpec.equal((String)"node", (String)((NodeAffinity)affinity).getNodeName());
        } else {
            if (!(affinity instanceof ClusterAffinity)) return this.performLocatedAction(locator, locatedAction);
            filterSpec = FilterSpec.equal((String)"cluster", (String)((ClusterAffinity)affinity).getClusterName());
        }
        try (ServicesQueue servicesQueue = this.discover(filterSpec);){
            while (true) {
                URI uri;
                try {
                    uri = servicesQueue.take();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    R r = null;
                    if (servicesQueue == null) return r;
                    if (throwable == null) {
                        servicesQueue.close();
                        return r;
                    }
                    try {
                        servicesQueue.close();
                        return r;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return r;
                    }
                }
                if (uri == null) {
                    R e = null;
                    return e;
                }
                EJBReceiver receiver = this.getTransportProvider(uri.getScheme());
                if (receiver != null) {
                    R r = locatedAction.execute(receiver, locator, Affinity.forUri(uri));
                    return r;
                }
                continue;
                break;
            }
        }
    }

    EJBClientInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    static {
        CONTEXT_MANAGER.setGlobalDefaultSupplier((Supplier)new ConfigurationBasedEJBClientContextSelector());
    }

    static interface LocatedAction<R, L extends EJBLocator<T>, T> {
        public R execute(EJBReceiver var1, L var2, Affinity var3) throws Exception;
    }

    public static final class Builder {
        List<EJBClientInterceptor> interceptors;
        List<EJBTransportProvider> transportProviders;

        public Builder() {
        }

        Builder(EJBClientContext ejbClientContext) {
            EJBTransportProvider[] transportProviders;
            EJBClientInterceptor[] interceptors = ejbClientContext.getInterceptors();
            if (interceptors.length > 0) {
                this.interceptors = new ArrayList<EJBClientInterceptor>(Arrays.asList(interceptors));
            }
            if ((transportProviders = ejbClientContext.getTransportProviders()).length > 0) {
                this.transportProviders = new ArrayList<EJBTransportProvider>(Arrays.asList(transportProviders));
            }
        }

        public void addInterceptor(EJBClientInterceptor interceptor) {
            if (interceptor == null) {
                throw new IllegalArgumentException("interceptor is null");
            }
            if (this.interceptors == null) {
                this.interceptors = new ArrayList<EJBClientInterceptor>();
            }
            this.interceptors.add(interceptor);
        }

        public void addTransportProvider(EJBTransportProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException("provider is null");
            }
            if (this.transportProviders == null) {
                this.transportProviders = new ArrayList<EJBTransportProvider>();
            }
            this.transportProviders.add(provider);
        }

        public EJBClientContext build() {
            return new EJBClientContext(this);
        }
    }
}

