/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.transaction.Transaction;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKeys;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBMethodLocator;
import org.jboss.ejb.client.RequestSendFailedException;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.protocol.remote.PackedInteger;
import org.jboss.ejb.protocol.remote.Protocol;
import org.jboss.ejb.protocol.remote.ProtocolV1ClassTable;
import org.jboss.ejb.protocol.remote.ProtocolV1ObjectTable;
import org.jboss.ejb.protocol.remote.ProtocolV3ClassTable;
import org.jboss.ejb.protocol.remote.ProtocolV3ObjectTable;
import org.jboss.invocation.AsynchronousInterceptor;
import org.jboss.marshalling.AbstractClassResolver;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.UTFUtils;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3._private.IntIndexHashMap;
import org.jboss.remoting3.util.MessageTracker;
import org.jboss.remoting3.util.StreamUtils;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.xnio.IoUtils;

public final class RemoteServer {
    private final Channel channel;
    private final int version;
    private final MessageTracker messageTracker;
    private final MarshallerFactory marshallerFactory;
    private final MarshallingConfiguration configuration;
    private final IntIndexHashMap<InProgress> invocations = new IntIndexHashMap(InProgress::getInvId);

    RemoteServer(Channel channel, int version, MessageTracker messageTracker) {
        this.channel = channel;
        this.version = version;
        this.messageTracker = messageTracker;
        MarshallingConfiguration configuration = new MarshallingConfiguration();
        if (version < 3) {
            configuration.setClassTable((ClassTable)ProtocolV1ClassTable.INSTANCE);
            configuration.setObjectTable((ObjectTable)ProtocolV1ObjectTable.INSTANCE);
            configuration.setVersion(2);
        } else {
            configuration.setClassTable((ClassTable)ProtocolV3ClassTable.INSTANCE);
            configuration.setObjectTable((ObjectTable)ProtocolV3ObjectTable.INSTANCE);
            configuration.setVersion(4);
        }
        this.marshallerFactory = new RiverMarshallerFactory();
        this.configuration = configuration;
    }

    public static OpenListener createOpenListener(final Function<RemoteServer, Association> associationFactory) {
        return new OpenListener(){

            public void channelOpened(Channel channel) {
                final MessageTracker messageTracker = new MessageTracker(channel, ((Integer)channel.getOption(RemotingOptions.MAX_OUTBOUND_MESSAGES)).intValue());
                channel.receiveMessage(new Channel.Receiver(){

                    public void handleError(Channel channel, IOException error) {
                    }

                    public void handleEnd(Channel channel) {
                    }

                    public void handleMessage(Channel channel, MessageInputStream message) {
                        int version;
                        try {
                            version = Math.min(3, StreamUtils.readInt8((InputStream)message));
                            while (message.read() != -1) {
                                message.skip(Long.MAX_VALUE);
                            }
                        }
                        catch (IOException e) {
                            IoUtils.safeClose((Closeable)channel);
                            return;
                        }
                        RemoteServer remoteServer = new RemoteServer(channel, version, messageTracker);
                        Association association = (Association)associationFactory.apply(remoteServer);
                        channel.receiveMessage(remoteServer.getReceiver(association));
                    }
                });
                try (MessageOutputStream mos = messageTracker.openMessage();){
                    mos.writeByte(3);
                    mos.write(Protocol.RIVER_BYTES);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    IoUtils.safeClose((Closeable)channel);
                }
                catch (IOException e) {
                    IoUtils.safeClose((Closeable)channel);
                }
            }

            public void registrationTerminated() {
            }
        };
    }

    Channel.Receiver getReceiver(Association association) {
        return new ReceiverImpl(association);
    }

    public void writeClusterTopologyUpdate(Object topology) throws IOException {
    }

    public void writeClusterRemoval(List<String> nodeNames) throws IOException {
    }

    private void writeFailedResponse(int invId, Exception e) {
        try (MessageOutputStream os = this.messageTracker.openMessageUninterruptibly();){
            os.writeByte(6);
            os.writeShort(invId);
            Marshaller marshaller = this.marshallerFactory.createMarshaller(this.configuration);
            marshaller.start(Marshalling.createByteOutput((OutputStream)os));
            marshaller.writeObject((Object)new RequestSendFailedException(e));
            marshaller.writeByte(0);
            marshaller.finish();
        }
        catch (IOException e2) {
            Logs.REMOTING.trace("EJB response write failed", e2);
        }
    }

    static /* synthetic */ void access$000(RemoteServer x0, int x1, Exception x2) {
        x0.writeFailedResponse(x1, x2);
    }

    static final class ServerClassResolver
    extends AbstractClassResolver {
        private ClassLoader classLoader;

        ServerClassResolver() {
            super(true);
        }

        protected ClassLoader getClassLoader() {
            ClassLoader classLoader = this.classLoader;
            return classLoader == null ? ((Object)((Object)this)).getClass().getClassLoader() : classLoader;
        }

        void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader == null ? ((Object)((Object)this)).getClass().getClassLoader() : classLoader;
        }
    }

    static final class InProgress {
        private final IncomingInvocation incomingInvocation;
        private final AsynchronousInterceptor.CancellationHandle cancellationHandle;

        InProgress(IncomingInvocation incomingInvocation, AsynchronousInterceptor.CancellationHandle cancellationHandle) {
            this.incomingInvocation = incomingInvocation;
            this.cancellationHandle = cancellationHandle;
        }

        IncomingInvocation getIncomingInvocation() {
            return this.incomingInvocation;
        }

        AsynchronousInterceptor.CancellationHandle getCancellationHandle() {
            return this.cancellationHandle;
        }

        int getInvId() {
            return this.incomingInvocation.getInvId();
        }
    }

    public final class IncomingInvocation
    extends Incoming {
        private final Map<String, Object> attachments;
        private final EJBMethodLocator methodLocator;
        private final Object[] parameters;
        private final int responseCompressLevel;

        IncomingInvocation(int invId, Affinity weakAffinity, SecurityIdentity identity, Transaction transaction, EJBIdentifier identifier, Map<String, Object> attachments, EJBMethodLocator methodLocator, Object[] parameters, int responseCompressLevel) {
            super(invId, weakAffinity, identity, transaction, identifier);
            this.attachments = attachments;
            this.methodLocator = methodLocator;
            this.parameters = parameters;
            this.responseCompressLevel = responseCompressLevel;
        }

        public Map<String, Object> getAttachments() {
            return this.attachments;
        }

        public EJBMethodLocator getMethodLocator() {
            return this.methodLocator;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public int getResponseCompressLevel() {
            return this.responseCompressLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeCancellation() {
            if (RemoteServer.this.version >= 3) {
                try (MessageOutputStream os = RemoteServer.this.messageTracker.openMessageUninterruptibly();){
                    os.writeByte(7);
                    os.writeShort(this.getInvId());
                }
                catch (IOException e) {
                    Logs.REMOTING.trace("EJB response write failed", e);
                }
                finally {
                    RemoteServer.this.invocations.removeKey(this.getInvId());
                }
            } else {
                this.writeException(Logs.REMOTING.requestCancelled());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeResponse(Object response) {
            try (MessageOutputStream os = RemoteServer.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(this.responseCompressLevel >= 0 ? 27 : 5);
                os.writeShort(this.getInvId());
                try (DeflaterOutputStream output = this.responseCompressLevel >= 0 ? new DeflaterOutputStream((OutputStream)os, new Deflater(this.responseCompressLevel, false)) : os;){
                    Marshaller marshaller = RemoteServer.this.marshallerFactory.createMarshaller(RemoteServer.this.configuration);
                    marshaller.start(Marshalling.createByteOutput((OutputStream)output));
                    marshaller.writeObject(response);
                    int count = this.attachments.size();
                    if (count > 255) {
                        marshaller.writeByte(255);
                    } else {
                        marshaller.writeByte(count);
                    }
                    int i = 0;
                    for (Map.Entry<String, Object> entry : this.attachments.entrySet()) {
                        marshaller.writeObject((Object)entry.getKey());
                        marshaller.writeObject(entry.getValue());
                        if (i++ != 255) continue;
                        break;
                    }
                    marshaller.finish();
                }
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB response write failed", e);
            }
            finally {
                RemoteServer.this.invocations.removeKey(this.getInvId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeException(Exception response) {
            try (MessageOutputStream os = RemoteServer.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(6);
                os.writeShort(this.getInvId());
                Marshaller marshaller = RemoteServer.this.marshallerFactory.createMarshaller(RemoteServer.this.configuration);
                marshaller.start(Marshalling.createByteOutput((OutputStream)os));
                marshaller.writeObject((Object)response);
                marshaller.writeByte(0);
                marshaller.finish();
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB response write failed", e);
            }
            finally {
                RemoteServer.this.invocations.removeKey(this.getInvId());
            }
        }
    }

    public final class IncomingSessionOpen
    extends Incoming {
        public IncomingSessionOpen(int invId, Affinity weakAffinity, SecurityIdentity identity, Transaction transaction, EJBIdentifier identifier) {
            super(invId, weakAffinity, identity, transaction, identifier);
        }

        public void writeResponse(SessionID sessionID) {
            try (MessageOutputStream os = RemoteServer.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(2);
                os.writeShort(this.getInvId());
                byte[] encodedForm = sessionID.getEncodedForm();
                PackedInteger.writePackedInteger((DataOutput)os, encodedForm.length);
                os.write(encodedForm);
                if (1 <= RemoteServer.this.version && RemoteServer.this.version <= 2) {
                    Marshaller marshaller = RemoteServer.this.marshallerFactory.createMarshaller(RemoteServer.this.configuration);
                    marshaller.start(Marshalling.createByteOutput((OutputStream)os));
                    marshaller.writeObject((Object)this.getWeakAffinity());
                    marshaller.finish();
                }
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB session open response write failed", e);
            }
        }
    }

    abstract class Incoming {
        private final int invId;
        private final Affinity weakAffinity;
        private final SecurityIdentity identity;
        private final Transaction transaction;
        private final EJBIdentifier identifier;

        Incoming(int invId, Affinity weakAffinity, SecurityIdentity identity, Transaction transaction, EJBIdentifier identifier) {
            this.invId = invId;
            this.weakAffinity = weakAffinity;
            this.identity = identity;
            this.transaction = transaction;
            this.identifier = identifier;
        }

        int getInvId() {
            return this.invId;
        }

        public Affinity getWeakAffinity() {
            return this.weakAffinity;
        }

        public SecurityIdentity getIdentity() {
            return this.identity;
        }

        public Transaction getTransaction() {
            return this.transaction;
        }

        public EJBIdentifier getIdentifier() {
            return this.identifier;
        }
    }

    class ReceiverImpl
    implements Channel.Receiver {
        private final Association association;

        ReceiverImpl(Association association) {
            this.association = association;
        }

        public void handleError(Channel channel, IOException error) {
            this.association.closed();
        }

        public void handleEnd(Channel channel) {
            this.association.closed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void handleMessage(Channel channel, MessageInputStream message) {
            try {
                code = message.readUnsignedByte();
                switch (code) {
                    case 3: 
                    case 27: {
                        invId = message.readUnsignedShort();
                        try {
                            input = code == 27 ? new InflaterInputStream((InputStream)message) : message;
                            var6_12 = null;
                            this.handleInvocationRequest(invId, input);
                            if (input == null) break;
                            if (var6_12 == null) ** GOTO lbl21
                            try {
                                input.close();
                                ** break;
lbl16:
                                // 1 sources

                            }
                            catch (Throwable var7_13) {
                                var6_12.addSuppressed(var7_13);
                                ** break;
                            }
lbl20:
                            // 1 sources

                            break;
lbl21:
                            // 1 sources

                            input.close();
                            ** break;
lbl23:
                            // 1 sources

                            break;
                            catch (Throwable var7_14) {
                                try {
                                    var6_12 = var7_14;
                                    throw var7_14;
                                }
                                catch (Throwable var8_15) {
                                    if (input != null) {
                                        if (var6_12 != null) {
                                            try {
                                                input.close();
                                            }
                                            catch (Throwable var9_16) {
                                                var6_12.addSuppressed(var9_16);
                                            }
                                        } else {
                                            input.close();
                                        }
                                    }
                                    throw var8_15;
                                }
                            }
                        }
                        catch (IOException | ClassNotFoundException e) {
                            RemoteServer.access$000(RemoteServer.this, invId, e);
                            ** break;
                        }
lbl42:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        invId = message.readUnsignedShort();
                        try {
                            this.handleSessionOpenRequest(invId, message);
                            ** break;
lbl48:
                            // 1 sources

                        }
                        catch (IOException e) {
                            RemoteServer.access$000(RemoteServer.this, invId, e);
                            ** break;
                        }
lbl52:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        invId = message.readUnsignedShort();
                        try {
                            this.handleCancelRequest(invId, message);
                            ** break;
lbl58:
                            // 1 sources

                        }
                        catch (IOException var5_11) {
                            ** break;
                        }
lbl61:
                        // 1 sources

                        break;
                    }
                    default: {
                        Logs.REMOTING.invalidMessageReceived(code);
                        break;
                    }
                }
            }
            catch (IOException var3_4) {
            }
            finally {
                IoUtils.safeClose((Closeable)message);
                channel.receiveMessage((Channel.Receiver)this);
            }
        }

        void handleCancelRequest(int invId, MessageInputStream message) throws IOException {
            boolean cancelIfRunning = RemoteServer.this.version >= 3 && message.readBoolean();
            InProgress inProgress = (InProgress)RemoteServer.this.invocations.get(invId);
            if (inProgress != null) {
                inProgress.getCancellationHandle().cancel(cancelIfRunning);
            }
        }

        void handleSessionOpenRequest(int invId, MessageInputStream inputStream) throws IOException {
            int securityContext;
            String appName = inputStream.readUTF();
            String moduleName = inputStream.readUTF();
            String distName = inputStream.readUTF();
            String beanName = inputStream.readUTF();
            if (RemoteServer.this.version >= 3) {
                securityContext = inputStream.readInt();
                int transactionContext = inputStream.readUnsignedShort();
            } else {
                securityContext = 0;
                boolean transactionContext = false;
            }
            Connection connection = RemoteServer.this.channel.getConnection();
            Transaction transaction = null;
            this.association.receiveSessionOpenRequest(new IncomingSessionOpen(invId, Affinity.NONE, connection.getLocalIdentity(securityContext), transaction, new EJBIdentifier(appName, moduleName, beanName, distName)));
        }

        void handleInvocationRequest(int invId, InputStream input) throws IOException, ClassNotFoundException {
            SecurityIdentity identity;
            EJBLocator locator;
            EJBMethodLocator methodLocator;
            MarshallingConfiguration configuration = RemoteServer.this.configuration.clone();
            ServerClassResolver classResolver = new ServerClassResolver();
            configuration.setClassResolver((ClassResolver)classResolver);
            Unmarshaller unmarshaller = RemoteServer.this.marshallerFactory.createUnmarshaller(configuration);
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            Affinity weakAffinity = Affinity.NONE;
            int responseCompressLevel = -1;
            Transaction transaction = null;
            Connection connection = RemoteServer.this.channel.getConnection();
            if (RemoteServer.this.version >= 3) {
                String appName = (String)unmarshaller.readObject(String.class);
                String moduleName = (String)unmarshaller.readObject(String.class);
                classResolver.setClassLoader(this.association.mapClassLoader(appName, moduleName));
                methodLocator = (EJBMethodLocator)unmarshaller.readObject(EJBMethodLocator.class);
                locator = (EJBLocator)unmarshaller.readObject(EJBLocator.class);
                if (appName != locator.getAppName() || moduleName != locator.getModuleName()) {
                    throw Logs.REMOTING.mismatchedMethodLocation();
                }
                weakAffinity = (Affinity)unmarshaller.readObject(Affinity.class);
                if (weakAffinity == null) {
                    weakAffinity = Affinity.NONE;
                }
                int flags = unmarshaller.readUnsignedByte();
                responseCompressLevel = flags & 0xF;
                int identityId = unmarshaller.readUnsignedShort();
                int transactionId = unmarshaller.readUnsignedShort();
                identity = identityId == 0 ? connection.getLocalIdentity() : connection.getLocalIdentity(identityId);
                transaction = null;
            } else {
                assert (RemoteServer.this.version <= 2);
                String sigString = UTFUtils.readUTFZBytes((ByteInput)unmarshaller);
                String appName = (String)unmarshaller.readObject(String.class);
                String moduleName = (String)unmarshaller.readObject(String.class);
                classResolver.setClassLoader(this.association.mapClassLoader(appName, moduleName));
                String beanName = (String)unmarshaller.readObject(String.class);
                String distinctName = (String)unmarshaller.readObject(String.class);
                identity = connection.getLocalIdentity();
                locator = (EJBLocator)unmarshaller.readObject(EJBLocator.class);
                if (appName != locator.getAppName() || moduleName != locator.getModuleName() || beanName != locator.getBeanName() || distinctName != locator.getDistinctName()) {
                    throw Logs.REMOTING.mismatchedMethodLocation();
                }
                String methodName = "";
                int count = 0;
                int i = 0;
                while (i != -1) {
                    ++count;
                    i = sigString.indexOf(44, i);
                }
                String[] parameterTypeNames = new String[count];
                int j = 0;
                int i2 = 0;
                while (i2 != -1) {
                    int n = sigString.indexOf(44, i2);
                    parameterTypeNames[j++] = n == -1 ? sigString.substring(i2, n) : sigString.substring(i2);
                    i2 = n + 1;
                }
                methodLocator = EJBMethodLocator.create(methodName, parameterTypeNames);
            }
            Object[] parameters = new Object[methodLocator.getParameterCount()];
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = unmarshaller.readObject();
            }
            int attachmentCount = PackedInteger.readPackedInteger((DataInput)unmarshaller);
            HashMap<String, Object> attachments = new HashMap<String, Object>(attachmentCount);
            for (int i = 0; i < attachmentCount; ++i) {
                String attName = (String)unmarshaller.readObject(String.class);
                if (attName.equals("org.jboss.ejb.client.invocation.attachments")) {
                    if (RemoteServer.this.version <= 2) {
                        Map map = (Map)unmarshaller.readObject(Map.class);
                        Object transactionIdObject = map.get(AttachmentKeys.TRANSACTION_ID_KEY);
                        if (transactionIdObject != null) {
                            TransactionID transactionId = (TransactionID)transactionIdObject;
                            transaction = this.association.lookupLegacyTransaction(transactionId);
                        }
                        if ((weakAffinity = (Affinity)map.get(AttachmentKeys.WEAK_AFFINITY)) != null) continue;
                        weakAffinity = Affinity.NONE;
                        continue;
                    }
                    unmarshaller.readObject();
                    continue;
                }
                attachments.put(attName, unmarshaller.readObject());
            }
            unmarshaller.finish();
            IncomingInvocation incomingInvocation = new IncomingInvocation(invId, weakAffinity, identity, transaction, locator.getIdentifier(), attachments, methodLocator, parameters, responseCompressLevel);
            AsynchronousInterceptor.CancellationHandle handle = this.association.receiveInvocationRequest(incomingInvocation);
            RemoteServer.this.invocations.put((Object)new InProgress(incomingInvocation, handle));
        }
    }

    public static interface Association {
        public ClassLoader mapClassLoader(String var1, String var2);

        public AsynchronousInterceptor.CancellationHandle receiveInvocationRequest(IncomingInvocation var1);

        public void receiveSessionOpenRequest(IncomingSessionOpen var1);

        public void closed();

        public Transaction lookupLegacyTransaction(TransactionID var1);
    }
}

