/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb._private.NetworkUtil;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.ConfigurationBasedEJBClientContextSelector;
import org.jboss.ejb.client.EJBClientConnection;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBTransportProvider;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.client.TransactionInterceptor;
import org.jboss.ejb.client.URIAffinity;
import org.wildfly.common.Assert;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.Discovery;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceType;
import org.wildfly.discovery.ServicesQueue;

public final class EJBClientContext
extends Attachable
implements Contextual<EJBClientContext> {
    public static final ServiceType EJB_SERVICE_TYPE = ServiceType.of((String)"ejb", (String)"jboss");
    private static final ContextManager<EJBClientContext> CONTEXT_MANAGER = new ContextManager(EJBClientContext.class, "jboss.ejb.client");
    private static final Supplier<Discovery> DISCOVERY_SUPPLIER = AccessController.doPrivileged(() -> ((ContextManager)Discovery.getContextManager()).getPrivilegedSupplier());
    private static final Supplier<EJBClientContext> GETTER = AccessController.doPrivileged(() -> CONTEXT_MANAGER.getPrivilegedSupplier());
    private static final EJBClientInterceptor[] NO_INTERCEPTORS = new EJBClientInterceptor[0];
    private static final EJBTransportProvider[] NO_TRANSPORT_PROVIDERS = new EJBTransportProvider[0];
    public static final String FILTER_ATTR_EJB_MODULE = "ejb-module";
    public static final String FILTER_ATTR_EJB_MODULE_DISTINCT = "ejb-module-distinct";
    public static final String FILTER_ATTR_NODE = "node";
    public static final String FILTER_ATTR_CLUSTER = "cluster";
    public static final String FILTER_ATTR_SOURCE_IP = "source-ip";
    private final EJBClientInterceptor[] interceptors;
    private final EJBTransportProvider[] transportProviders;
    private final long invocationTimeout;
    private final EJBReceiverContext receiverContext;
    private final List<EJBClientConnection> configuredConnections;

    EJBClientContext(Builder builder) {
        List<EJBClientInterceptor> builderInterceptors = builder.interceptors;
        this.interceptors = builderInterceptors == null || builderInterceptors.isEmpty() ? NO_INTERCEPTORS : builderInterceptors.toArray(NO_INTERCEPTORS);
        List<EJBTransportProvider> builderTransportProviders = builder.transportProviders;
        this.transportProviders = builderTransportProviders == null || builderTransportProviders.isEmpty() ? NO_TRANSPORT_PROVIDERS : builderTransportProviders.toArray(new EJBTransportProvider[builderTransportProviders.size()]);
        this.invocationTimeout = 0L;
        this.receiverContext = new EJBReceiverContext(this);
        List<EJBClientConnection> clientConnections = builder.clientConnections;
        this.configuredConnections = clientConnections == null || clientConnections.isEmpty() ? Collections.emptyList() : (clientConnections.size() == 1 ? Collections.singletonList(clientConnections.get(0)) : Collections.unmodifiableList(new ArrayList<EJBClientConnection>(clientConnections)));
        for (EJBTransportProvider transportProvider : this.transportProviders) {
            transportProvider.notifyRegistered(this.receiverContext);
        }
    }

    public ContextManager<EJBClientContext> getInstanceContextManager() {
        return EJBClientContext.getContextManager();
    }

    public static ContextManager<EJBClientContext> getContextManager() {
        return CONTEXT_MANAGER;
    }

    public long getInvocationTimeout() {
        return this.invocationTimeout;
    }

    public List<EJBClientConnection> getConfiguredConnections() {
        return this.configuredConnections;
    }

    public EJBClientContext withAddedInterceptors(EJBClientInterceptor ... interceptors) {
        if (interceptors == null) {
            return this;
        }
        int length = interceptors.length;
        if (length == 0) {
            return this;
        }
        Builder builder = new Builder(this);
        boolean construct = false;
        for (EJBClientInterceptor interceptor : interceptors) {
            if (interceptor == null) continue;
            builder.addInterceptor(interceptor);
            construct = true;
        }
        return construct ? builder.build() : this;
    }

    public EJBClientContext withAddedTransportProviders(EJBTransportProvider ... transportProviders) {
        if (transportProviders == null) {
            return this;
        }
        int length = transportProviders.length;
        if (length == 0) {
            return this;
        }
        Builder builder = new Builder(this);
        boolean construct = false;
        for (EJBTransportProvider transportProvider : transportProviders) {
            if (transportProvider == null) continue;
            builder.addTransportProvider(transportProvider);
            construct = true;
        }
        return construct ? builder.build() : this;
    }

    EJBReceiver getTransportProvider(String scheme) {
        for (EJBTransportProvider transportProvider : this.transportProviders) {
            if (!transportProvider.supportsProtocol(scheme)) continue;
            return transportProvider.getReceiver(this.receiverContext, scheme);
        }
        return null;
    }

    ServicesQueue discover(FilterSpec filterSpec) {
        return this.getDiscovery().discover(EJB_SERVICE_TYPE, filterSpec);
    }

    EJBTransportProvider[] getTransportProviders() {
        return this.transportProviders;
    }

    Discovery getDiscovery() {
        return DISCOVERY_SUPPLIER.get();
    }

    public static EJBClientContext getCurrent() {
        EJBClientContext clientContext = GETTER.get();
        if (clientContext == null) {
            throw Logs.MAIN.noEJBClientContextAvailable();
        }
        return clientContext;
    }

    public static EJBClientContext requireCurrent() {
        return EJBClientContext.getCurrent();
    }

    <T> StatefulEJBLocator<T> createSession(StatelessEJBLocator<T> statelessLocator) throws Exception {
        LocatedAction action = (receiver, originalLocator, newAffinity) -> receiver.createSession(originalLocator.withNewAffinity(newAffinity));
        return this.performLocatedAction(statelessLocator, action);
    }

    <R, L extends EJBLocator<T>, T> R performLocatedAction(L locator, LocatedAction<R, L, T> locatedAction) throws Exception {
        String scheme;
        Affinity affinity = locator.getAffinity();
        if (affinity instanceof NodeAffinity) {
            return this.discoverFirst(locator, locatedAction);
        }
        if (affinity instanceof ClusterAffinity) {
            return this.discoverFirst(locator, locatedAction);
        }
        if (affinity == Affinity.LOCAL) {
            scheme = "local";
        } else if (affinity instanceof URIAffinity) {
            scheme = affinity.getUri().getScheme();
        } else {
            assert (affinity == Affinity.NONE);
            return this.discoverFirst(locator, locatedAction);
        }
        EJBReceiver transportProvider = this.getTransportProvider(scheme);
        if (transportProvider == null) {
            throw Logs.MAIN.noEJBReceiverAvailable(locator);
        }
        return locatedAction.execute(transportProvider, locator, locator.getAffinity());
    }

    /*
     * Unable to fully structure code
     */
    <R, L extends EJBLocator<T>, T> R discoverFirst(L locator, LocatedAction<R, L, T> locatedAction) throws Exception {
        block27: {
            affinity = locator.getAffinity();
            if (affinity == Affinity.NONE) {
                appName = locator.getAppName();
                moduleName = locator.getModuleName();
                beanName = locator.getBeanName();
                distinctName = locator.getDistinctName();
                filterSpec = distinctName != null && !distinctName.isEmpty() ? (appName.isEmpty() ? FilterSpec.equal((String)"ejb-module-distinct", (String)('\"' + moduleName + '/' + distinctName + '\"')) : FilterSpec.equal((String)"ejb-module-distinct", (String)('\"' + appName + '/' + moduleName + '/' + distinctName + '\"'))) : (appName.isEmpty() ? FilterSpec.equal((String)"ejb-module", (String)('\"' + moduleName + '\"')) : FilterSpec.equal((String)"ejb-module", (String)('\"' + appName + '/' + moduleName + '\"')));
            } else if (affinity instanceof NodeAffinity) {
                filterSpec = FilterSpec.equal((String)"node", (String)((NodeAffinity)affinity).getNodeName());
            } else if (affinity instanceof ClusterAffinity) {
                filterSpec = FilterSpec.equal((String)"cluster", (String)((ClusterAffinity)affinity).getClusterName());
            } else {
                return this.performLocatedAction(locator, locatedAction);
            }
            servicesQueue = this.discover(filterSpec);
            var8_7 = null;
            block13: while (true) {
                try {
                    block14: while (true) {
                        try {
                            serviceURL = servicesQueue.takeService();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw Logs.MAIN.operationInterrupted();
                        }
                        if (serviceURL == null) {
                            throw Logs.MAIN.noEJBReceiverAvailable(locator);
                        }
                        uri = serviceURL.getLocationURI();
                        receiver = this.getTransportProvider(uri.getScheme());
                        if (receiver == null) continue;
                        values = serviceURL.getAttributeValues("source-ip");
                        matches = values.isEmpty();
                        if (matches) {
                            break block27;
                        }
                        sourceAddress = receiver.getSourceAddress(uri);
                        inetAddress = sourceAddress instanceof InetSocketAddress != false ? ((InetSocketAddress)sourceAddress).getAddress() : null;
                        var15_17 = values.iterator();
                        while (true) {
                            if (var15_17.hasNext()) ** break;
                            continue block14;
                            value = (AttributeValue)var15_17.next();
                            try {
                                if (!value.isString() || (string = value.toString()).codePointAt(0) != 91 || (closeBrace = string.indexOf(93, 1)) == -1) continue;
                                matchAddress = InetAddress.getByName(string.substring(1, closeBrace));
                                if (string.codePointAt(closeBrace + 1) != 47) continue;
                                mask = Integer.parseInt(string.substring(closeBrace + 2));
                                if (!(inetAddress == null ? mask == 0 : NetworkUtil.belongsToNetwork(inetAddress, matchAddress, mask) != false)) continue;
                                continue block13;
                            }
                            catch (RuntimeException var17_20) {
                                continue;
                            }
                            break;
                        }
                        break;
                    }
                }
                catch (Throwable var9_12) {
                    var8_7 = var9_12;
                    throw var9_12;
                }
            }
            finally {
                if (servicesQueue != null) {
                    if (var8_7 != null) {
                        try {
                            servicesQueue.close();
                        }
                        catch (Throwable var9_11) {
                            var8_7.addSuppressed(var9_11);
                        }
                    } else {
                        servicesQueue.close();
                    }
                }
            }
        }
        uri = serviceURL.getLocationURI();
        return locatedAction.execute(receiver, locator, Affinity.forUri(uri));
    }

    EJBClientInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    private static int getInt(byte[] b, int offs) {
        return (b[offs] & 0xFF) << 24 | (b[offs + 1] & 0xFF) << 16 | (b[offs + 2] & 0xFF) << 8 | b[offs + 3] & 0xFF;
    }

    private static long getLong(byte[] b, int offs) {
        return ((long)EJBClientContext.getInt(b, offs) & 0xFFFFFFFFL) << 32 | (long)EJBClientContext.getInt(b, offs + 4) & 0xFFFFFFFFL;
    }

    private static int nwsl(int arg, int places) {
        return places <= 0 ? arg : (places >= 32 ? 0 : arg << places);
    }

    private static long nwsl(long arg, int places) {
        return places <= 0 ? arg : (places >= 64 ? 0L : arg << places);
    }

    static {
        CONTEXT_MANAGER.setGlobalDefaultSupplier((Supplier)new ConfigurationBasedEJBClientContextSelector());
    }

    static interface LocatedAction<R, L extends EJBLocator<T>, T> {
        public R execute(EJBReceiver var1, L var2, Affinity var3) throws Exception;
    }

    public static final class Builder {
        List<EJBClientInterceptor> interceptors;
        List<EJBTransportProvider> transportProviders;
        List<EJBClientConnection> clientConnections;

        public Builder() {
            this.interceptors = new ArrayList<EJBClientInterceptor>();
            this.interceptors.add(new TransactionInterceptor());
        }

        Builder(EJBClientContext ejbClientContext) {
            EJBTransportProvider[] transportProviders;
            EJBClientInterceptor[] interceptors = ejbClientContext.getInterceptors();
            if (interceptors.length > 0) {
                this.interceptors = new ArrayList<EJBClientInterceptor>(Arrays.asList(interceptors));
            }
            if ((transportProviders = ejbClientContext.getTransportProviders()).length > 0) {
                this.transportProviders = new ArrayList<EJBTransportProvider>(Arrays.asList(transportProviders));
            }
            this.clientConnections = new ArrayList<EJBClientConnection>(ejbClientContext.getConfiguredConnections());
        }

        public void addInterceptor(EJBClientInterceptor interceptor) {
            Assert.checkNotNullParam((String)"interceptor", (Object)interceptor);
            if (this.interceptors == null) {
                this.interceptors = new ArrayList<EJBClientInterceptor>();
            }
            this.interceptors.add(interceptor);
        }

        public void addTransportProvider(EJBTransportProvider provider) {
            Assert.checkNotNullParam((String)"provider", (Object)provider);
            if (this.transportProviders == null) {
                this.transportProviders = new ArrayList<EJBTransportProvider>();
            }
            this.transportProviders.add(provider);
        }

        public void addClientConnection(EJBClientConnection connection) {
            Assert.checkNotNullParam((String)"connection", (Object)connection);
            if (this.clientConnections == null) {
                this.clientConnections = new ArrayList<EJBClientConnection>();
            }
            this.clientConnections.add(connection);
        }

        public EJBClientContext build() {
            return new EJBClientContext(this);
        }
    }
}

