/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import org.jboss.ejb.client.ClusterNodeSelector;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

public final class EJBClientCluster {
    private final String name;
    private final int maximumConnectedNodes;
    private final long connectTimeoutMilliseconds;
    private final ClusterNodeSelector clusterNodeSelector;
    private final AuthenticationConfiguration overrideConfiguration;

    EJBClientCluster(Builder builder) {
        this.name = builder.name;
        this.maximumConnectedNodes = builder.maximumConnectedNodes;
        this.connectTimeoutMilliseconds = builder.connectTimeoutMilliseconds;
        this.clusterNodeSelector = builder.clusterNodeSelector;
        this.overrideConfiguration = builder.overrideConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public int getMaximumConnectedNodes() {
        return this.maximumConnectedNodes;
    }

    public long getConnectTimeoutMilliseconds() {
        return this.connectTimeoutMilliseconds;
    }

    public ClusterNodeSelector getClusterNodeSelector() {
        return this.clusterNodeSelector;
    }

    public AuthenticationConfiguration getOverrideConfiguration() {
        return this.overrideConfiguration;
    }

    public static final class Builder {
        private String name;
        private int maximumConnectedNodes = 0;
        private long connectTimeoutMilliseconds = -1L;
        private ClusterNodeSelector clusterNodeSelector;
        private AuthenticationConfiguration overrideConfiguration;

        public void setName(String name) {
            Assert.checkNotNullParam((String)"name", (Object)name);
            this.name = name;
        }

        public void setMaximumConnectedNodes(int maximumConnectedNodes) {
            Assert.checkMinimumParameter((String)"maximumConnectedNodes", (int)0, (int)maximumConnectedNodes);
            this.maximumConnectedNodes = maximumConnectedNodes;
        }

        public void setConnectTimeoutMilliseconds(long connectTimeoutMilliseconds) {
            Assert.checkMinimumParameter((String)"connectTimeoutMilliseconds", (long)-1L, (long)connectTimeoutMilliseconds);
            this.connectTimeoutMilliseconds = connectTimeoutMilliseconds;
        }

        public void setClusterNodeSelector(ClusterNodeSelector clusterNodeSelector) {
            this.clusterNodeSelector = clusterNodeSelector;
        }

        public void setOverrideConfiguration(AuthenticationConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
        }

        public EJBClientCluster build() {
            Assert.checkNotNullParam((String)"name", (Object)this.name);
            return new EJBClientCluster(this);
        }
    }
}

