/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.security.AccessController;
import javax.ejb.CreateException;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.RequestSendFailedException;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.client.URIAffinity;
import org.jboss.ejb.protocol.remote.EJBClientChannel;
import org.jboss.ejb.protocol.remote.RemoteTransportProvider;
import org.jboss.remoting3.ClientServiceHandle;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.wildfly.common.Assert;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client.remote.RemoteNamingProvider;
import org.xnio.FinishedIoFuture;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

class RemoteEJBReceiver
extends EJBReceiver {
    static final AttachmentKey<EJBClientChannel> EJBCC_KEY = new AttachmentKey();
    private final RemoteTransportProvider remoteTransportProvider;
    private final EJBReceiverContext receiverContext;
    final ClientServiceHandle<EJBClientChannel> serviceHandle = new ClientServiceHandle("jboss.ejb", channel -> EJBClientChannel.construct(channel, this));
    final IoFuture.HandlingNotifier<Connection, EJBReceiverInvocationContext> notifier = new IoFuture.HandlingNotifier<Connection, EJBReceiverInvocationContext>(){

        public void handleDone(Connection connection, EJBReceiverInvocationContext attachment) {
            EJBClientChannel ejbClientChannel;
            try {
                ejbClientChannel = RemoteEJBReceiver.this.getClientChannel(connection);
            }
            catch (IOException e) {
                attachment.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed(new RequestSendFailedException(e, true)));
                return;
            }
            attachment.getClientInvocationContext().putAttachment(EJBCC_KEY, ejbClientChannel);
            ejbClientChannel.processInvocation(attachment);
        }

        public void handleCancelled(EJBReceiverInvocationContext attachment) {
            attachment.requestCancelled();
        }

        public void handleFailed(IOException exception, EJBReceiverInvocationContext attachment) {
            attachment.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed(new RequestSendFailedException(exception, true)));
        }
    };

    RemoteEJBReceiver(RemoteTransportProvider remoteTransportProvider, EJBReceiverContext receiverContext) {
        this.remoteTransportProvider = remoteTransportProvider;
        this.receiverContext = receiverContext;
    }

    RemoteTransportProvider getRemoteTransportProvider() {
        return this.remoteTransportProvider;
    }

    EJBReceiverContext getReceiverContext() {
        return this.receiverContext;
    }

    EJBClientChannel getClientChannel(Connection connection) throws IOException {
        try {
            return (EJBClientChannel)this.serviceHandle.getClientService(connection, OptionMap.EMPTY).getInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    @Override
    protected void processInvocation(EJBReceiverInvocationContext receiverContext) throws Exception {
        EJBClientInvocationContext clientInvocationContext = receiverContext.getClientInvocationContext();
        EJBLocator<?> locator = clientInvocationContext.getLocator();
        NamingProvider namingProvider = receiverContext.getNamingProvider();
        IoFuture<Connection> futureConnection = this.getConnection(locator, namingProvider);
        futureConnection.addNotifier(this.notifier, (Object)receiverContext);
    }

    @Override
    protected boolean cancelInvocation(EJBReceiverInvocationContext receiverContext, boolean cancelIfRunning) {
        NamingProvider namingProvider = receiverContext.getNamingProvider();
        EJBClientInvocationContext clientInvocationContext = receiverContext.getClientInvocationContext();
        EJBLocator<?> locator = clientInvocationContext.getLocator();
        try {
            EJBClientChannel channel = receiverContext.getClientInvocationContext().getAttachment(EJBCC_KEY);
            return channel != null && channel.cancelInvocation(receiverContext, cancelIfRunning);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected <T> StatefulEJBLocator<T> createSession(StatelessEJBLocator<T> statelessLocator) throws Exception {
        try {
            IoFuture<Connection> futureConnection = this.getConnection(statelessLocator, null);
            EJBClientChannel ejbClientChannel = this.getClientChannel((Connection)futureConnection.getInterruptibly());
            return ejbClientChannel.openSession(statelessLocator);
        }
        catch (IOException e) {
            CreateException createException = new CreateException("Failed to create stateful EJB: " + e.getMessage());
            createException.initCause((Throwable)e);
            throw createException;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CreateException("Stateful EJB creation interrupted");
        }
    }

    @Override
    protected boolean isConnected(URI uri) {
        IoFuture future = Endpoint.getCurrent().getConnectionIfExists(uri, "ejb", "jboss");
        try {
            return future != null && future.getStatus() == IoFuture.Status.DONE && ((Connection)future.get()).isOpen();
        }
        catch (IOException e) {
            throw Assert.unreachableCode();
        }
    }

    private <T> IoFuture<Connection> getConnection(EJBLocator<T> locator, NamingProvider namingProvider) throws Exception {
        URI target;
        Connection namingConnection = namingProvider instanceof RemoteNamingProvider ? ((RemoteNamingProvider)namingProvider).getPeerIdentity().getConnection() : null;
        Affinity affinity = locator.getAffinity();
        if (affinity instanceof URIAffinity) {
            target = affinity.getUri();
            if (namingConnection != null && target.equals(namingConnection.getPeerURI())) {
                return new FinishedIoFuture((Object)namingConnection);
            }
        } else {
            throw new IllegalArgumentException("Invalid EJB affinity");
        }
        return AccessController.doPrivileged(() -> Endpoint.getCurrent().getConnection(target, "ejb", "jboss"));
    }
}

