/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.UnsupportedEncodingException;
import org.jboss.ejb.client.TransactionID;

@Deprecated
public final class UserTransactionID
extends TransactionID {
    private static final long serialVersionUID = -791647046784989955L;
    private final transient String nodeName;

    UserTransactionID(byte[] encodedForm) {
        super(encodedForm);
        if (encodedForm[0] != 1) {
            throw UserTransactionID.wrongFormat();
        }
        int totalEncodedLength = encodedForm.length;
        byte nodeNameLength = encodedForm[1];
        if (nodeNameLength <= 0) {
            throw UserTransactionID.wrongFormat();
        }
        try {
            this.nodeName = new String(encodedForm, 2, (int)nodeNameLength, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw UserTransactionID.wrongFormat();
        }
        if (totalEncodedLength < nodeNameLength + 4) {
            throw UserTransactionID.wrongFormat();
        }
    }

    UserTransactionID(String name, int uniqueId) {
        this(UserTransactionID.encode(name, uniqueId));
    }

    private static byte[] encode(String name, int uniqueId) {
        byte[] nameBytes;
        try {
            nameBytes = name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw UserTransactionID.wrongFormat();
        }
        int length = nameBytes.length;
        if (length > 255) {
            throw UserTransactionID.wrongFormat();
        }
        byte[] target = new byte[6 + length];
        target[0] = 1;
        target[1] = (byte)length;
        System.arraycopy(nameBytes, 0, target, 2, length);
        target[2 + length] = (byte)(uniqueId >> 24);
        target[3 + length] = (byte)(uniqueId >> 16);
        target[4 + length] = (byte)(uniqueId >> 8);
        target[5 + length] = (byte)uniqueId;
        return target;
    }

    private static IllegalArgumentException wrongFormat() {
        return new IllegalArgumentException("Wrong session ID format");
    }

    public String getNodeName() {
        return this.nodeName;
    }
}

