/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.Arrays;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.wildfly.naming.client.NamingProvider;

public final class EJBReceiverInvocationContext {
    private final EJBClientInvocationContext clientInvocationContext;

    EJBReceiverInvocationContext(EJBClientInvocationContext clientInvocationContext) {
        this.clientInvocationContext = clientInvocationContext;
    }

    public void proceedAsynchronously() {
        this.clientInvocationContext.proceedAsynchronously();
    }

    public void resultReady(ResultProducer resultProducer) {
        this.clientInvocationContext.resultReady(resultProducer);
    }

    public void requestCancelled() {
        this.clientInvocationContext.cancelled();
    }

    public EJBClientInvocationContext getClientInvocationContext() {
        return this.clientInvocationContext;
    }

    public NamingProvider getNamingProvider() {
        return this.clientInvocationContext.getNamingProvider();
    }

    public static interface ResultProducer {
        public Object getResult() throws Exception;

        public void discardResult();

        public static class Immediate
        implements ResultProducer {
            private final Object result;

            public Immediate(Object result) {
                this.result = result;
            }

            @Override
            public Object getResult() throws Exception {
                return this.result;
            }

            @Override
            public void discardResult() {
            }
        }

        public static class Failed
        implements ResultProducer {
            private final Exception cause;

            public Failed(Exception cause) {
                this.cause = cause;
            }

            @Override
            public Object getResult() throws Exception {
                Exception cause = this.cause;
                StackTraceElement[] stackTrace = new Throwable().getStackTrace();
                cause.setStackTrace(Arrays.copyOfRange(stackTrace, 1, stackTrace.length));
                throw cause;
            }

            @Override
            public void discardResult() {
            }
        }
    }
}

