/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.net.URI;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.protocol.remote.RemoteEJBReceiver;
import org.jboss.ejb.protocol.remote.RemoteTransportProvider;
import org.jboss.remoting3.Endpoint;
import org.wildfly.discovery.Discovery;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceType;
import org.wildfly.discovery.ServicesQueue;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryRequest;
import org.wildfly.discovery.spi.DiscoveryResult;

final class RemotingClusteredEJBDiscoveryProvider
implements DiscoveryProvider {
    static final RemotingClusteredEJBDiscoveryProvider INSTANCE = new RemotingClusteredEJBDiscoveryProvider();

    private RemotingClusteredEJBDiscoveryProvider() {
        Endpoint.getCurrent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DiscoveryRequest discover(ServiceType serviceType, FilterSpec filterSpec, DiscoveryResult result) {
        if (!serviceType.implies(ServiceType.of((String)"ejb", (String)"jboss"))) {
            result.complete();
            return DiscoveryRequest.NULL;
        }
        EJBClientContext ejbClientContext = EJBClientContext.getCurrent();
        RemoteEJBReceiver ejbReceiver = ejbClientContext.getAttachment(RemoteTransportProvider.ATTACHMENT_KEY);
        if (ejbReceiver == null) {
            result.complete();
            return DiscoveryRequest.NULL;
        }
        try (ServicesQueue servicesQueue = Discovery.create((DiscoveryProvider)ejbReceiver.getRemoteTransportProvider().getClusterDiscoveryProvider()).discover(serviceType, filterSpec);){
            URI serviceURI = servicesQueue.take();
            if (serviceURI != null) {
                while (true) {
                    if (serviceURI == null) {
                        result.complete();
                        DiscoveryRequest discoveryRequest = DiscoveryRequest.NULL;
                        return discoveryRequest;
                    }
                    result.addMatch(serviceURI);
                    serviceURI = servicesQueue.take();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        result.complete();
        return DiscoveryRequest.NULL;
    }
}

