/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.URI;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.NodeAffinity;

public final class URIAffinity
extends Affinity {
    private static final long serialVersionUID = -8437624625197058354L;
    private final URI uri;

    URIAffinity(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI is null");
        }
        this.uri = uri;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    Object writeReplace() {
        String s = this.uri.getScheme();
        if (s.equals("node")) {
            return new NodeAffinity(this.uri.getSchemeSpecificPart());
        }
        if (s.equals("cluster")) {
            return new ClusterAffinity(this.uri.getSchemeSpecificPart());
        }
        if (s.equals("local")) {
            return LOCAL;
        }
        return this;
    }

    public String toString() {
        return String.format("URI<%s>", this.uri);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof URIAffinity && this.equals((URIAffinity)other);
    }

    @Override
    public boolean equals(Affinity other) {
        return other instanceof URIAffinity && this.equals((URIAffinity)other);
    }

    public boolean equals(URIAffinity other) {
        return other != null && this.uri.equals(other.uri);
    }

    @Override
    public int hashCode() {
        return this.uri.hashCode();
    }
}

