/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.qa.ejb.jndi;

import org.apache.log4j.Logger;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import java.util.Properties;

/**
 * @author ochaloup
 */
public class InitialContextDirectoryEAP5JNP extends InitialContextDirectory {
    private static final Logger log = Logger.getLogger(InitialContextDirectoryEAP5JNP.class);
    
    public InitialContextDirectoryEAP5JNP(String hostname, String port) {
        log.info("Using: " + this.getClass().getName() + " on host: " + hostname + ", port: " + port);
        try {
            ctx = createInitialContext(hostname, port);
        } catch(NamingException ne) {
            throw new RuntimeException(ne);
        }
    }
    
    public InitialContextDirectoryEAP5JNP(String hostname) {
        this(hostname, "1099");
    }
    
    public InitialContextDirectoryEAP5JNP() {
        this("localhost");
    }
    
    private InitialContext createInitialContext(String hostname, String port) throws NamingException {
        Properties env = new Properties();
        env.put(Context.INITIAL_CONTEXT_FACTORY, "org.jnp.interfaces.NamingContextFactory");
        env.put(Context.URL_PKG_PREFIXES, "org.jboss.naming:org.jnp.interfaces");        
        env.put(Context.PROVIDER_URL, "jnp://" + hostname + ":" + port);
        // env.setProperty(Context.SECURITY_PRINCIPAL, "admin");
        // env.setProperty(Context.SECURITY_CREDENTIALS, "admin");
        return new InitialContext(env);
    }
    
    public <T> String createJndiName(String earName, Class<T> beanClass, BeanType beanType) {
        earName = (earName == null || earName.trim().isEmpty()) ? "" : earName + "/";
        String interfaceType = "remote";
        if(beanType == BeanType.EJB2) {
            // returning home interface - no other is remotely available
            interfaceType = "home";
        }
        if(beanType == BeanType.ENTITY) {
            // entity bean are bound somelike strange - check resources/entity/ejb-jar.xml
            return String.format("%s%s", earName, beanClass.getSimpleName());
        }
        String jndiName = earName + beanClass.getSimpleName() + "/" + interfaceType;
        return jndiName;
    }
    
    @Override
    public <T> T lookup(String earName, String jarName, Class<?> beanClass, Class<T> beanInterface, BeanType beanType, String distinctName)
            throws NamingException {
        String name = createJndiName(earName, beanClass, beanType);
        return getBean(name, beanInterface);
    }
}
