package org.jboss.qa.ejb.backwardscompatibility.shared;

import java.util.*;


/**
 * Methods tries to take info from StaticProvider.VARIABLE 
 * and this information appends to passed value and returns this changed value.
 * 
 * @author ochaloup
 */
public class SendRequest implements SendRequestRemote {
    private String variable;
    private int variableNumber;

    public void setVariableParam(String var) {
        StaticInfoProvider.VARIABLE = var;
        this.variable = StaticInfoProvider.VARIABLE;
        this.variableNumber = Integer.valueOf(StaticInfoProvider.VARIABLE);
    }

    public boolean sendBoolean(boolean value) {
        return value;
    }

    public byte sendByte(byte value) {
        return (byte) (value + this.variableNumber);
    }

    public int sendInt(int value) {
        return value + this.variableNumber;
    }

    public short sendShort(short value) {
        return (short) (value + this.variableNumber);
    }

    public long sendLong(long value) {
        return value + this.variableNumber;
    }

    public float sendFloat(float value) {
        return value + this.variableNumber;
    }

    public double sendDouble(double value) {
        return value + this.variableNumber;
    }

    public char sendChar(char value) {
        return (char) (value + this.variableNumber);
    }

    public int[] sendIntArray(int[] value) {
        for(int i=0; i<value.length; i++) {
            value[i] += this.variableNumber;
        }
        return value;
    }
    
    public Boolean sendBoolean(Boolean value) {
        return value;
    }

    public Integer sendInteger(Integer value) {
        return value + this.variableNumber;
    }

    public Character sendCharacter(Character value) {
        return Character.valueOf((char) (value.charValue() + this.variableNumber));
    }

    public String sendString(String value) {
        return value + this.variable;
    }

    public Date sendDate(Date value) {
        return new Date(value.getTime() + this.variableNumber);
    }

    public List<String> sendStringList(List<String> value) {
        ListIterator<String> iter = value.listIterator(); 
        while(iter.hasNext()) {
            String element = iter.next(); 
            iter.set(element + this.variable);

        }
        return value;
    }

    public Map<Integer, String> sendStringMap(Map<Integer, String> value) {
        for(Integer key: value.keySet()) {
            value.put(key, String.valueOf(value.get(key)) + this.variable);
        }
        return value;
    }

    public Set<String> sendStringSet(Set<String> value) {
        Set<String>  result = new HashSet<String>();
        for(String v: value) {
            result.add(v + this.variable);
        }
        return result;
    }

}
