package org.jboss.qa.ejb.backwardscompatibility.shared;

/**
 * @author jmartisk
 * @since 11/29/12
 */
public class TestHelper {

    /**
     * Possible values are currently: [EAP6] EJB, REMOTE; [EAP5] HTTP, JNP
     */
    public static String JNDI_LOOKUP_TYPE_PROPERTY_NAME = "jndi.lookup.type";

    public static String EAP_VERSION_PROPERTY_NAME = "eap.version";

    public static int getEAPVersion() {
        return Integer.parseInt(System.getProperty(EAP_VERSION_PROPERTY_NAME));
    }

    public static String getJndiLookupType() {
        String jndiLookupType = System.getProperty(JNDI_LOOKUP_TYPE_PROPERTY_NAME);
        if(jndiLookupType == null) {
            String eapVersion = System.getProperty(EAP_VERSION_PROPERTY_NAME);
            if(eapVersion == null)
                throw new IllegalStateException("System property "+EAP_VERSION_PROPERTY_NAME+" is not defined");
            if(eapVersion.trim().equals("6"))
                return "ejb";
            if(eapVersion.trim().equals("5"))
                return "jnp";
            throw new IllegalStateException("System property "+EAP_VERSION_PROPERTY_NAME+" has unknown value: " + eapVersion);
        }
        return jndiLookupType;
    }

}
