package org.jboss.qa.ejb.backwardscompatibility.eap6only.clientinterceptor;

import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;

/**
 * @author Jan Martiska
 */
public class TestEJBClientInterceptorAddingContextData<T> implements EJBClientInterceptor {

    private final String key;
    private final T value;

    public TestEJBClientInterceptorAddingContextData(String key, T value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public void handleInvocation(EJBClientInvocationContext ejbClientInvocationContext) throws Exception {
        ejbClientInvocationContext.getContextData().put(key, value);
        ejbClientInvocationContext.sendRequest();
    }

    @Override
    public Object handleInvocationResult(EJBClientInvocationContext ejbClientInvocationContext)
            throws Exception {
        return ejbClientInvocationContext.getResult();
    }

}
