package org.jboss.qa.ejb.backwardscompatibility.eap6only.transactions;

import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.ejb.client.EJBClient;
import org.jboss.qa.ejb.backwardscompatibility.shared.TestHelper;
import org.jboss.qa.ejb.jndi.InitialContextDirectory;
import org.jboss.qa.ejb.jndi.InitialContextDirectoryFactory;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

import static org.jboss.qa.ejb.backwardscompatibility.TestCaseParent.EAP6_NODE_NAME;

/**
 * @author Jan Martiska
 */
@RunAsClient
@RunWith(Arquillian.class)
public class TransactionsTestCase {

    public static final String MODULE_NAME = "transactions-test";

    protected static InitialContextDirectory ctxDirectory;

    @Deployment(name = MODULE_NAME, testable = false)
    public static JavaArchive deployment() {
        final JavaArchive jar = ShrinkWrap.create(JavaArchive.class, MODULE_NAME + ".jar");
        jar.addPackage(TransactionsTestCase.class.getPackage());
        return jar;
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        // only for non-scoped EJB client contexts
        Assume.assumeTrue(TestHelper.getJndiLookupType().equalsIgnoreCase("ejb"));
        ctxDirectory = InitialContextDirectoryFactory
                .createDirectory();
    }

    /**
     * Test to verify that the EJB client can propagate a transaction to the server so it can call
     * a method with TransactionAttribute.MANDATORY
     * @throws SystemException
     * @throws NotSupportedException
     * @throws HeuristicRollbackException
     * @throws HeuristicMixedException
     * @throws RollbackException
     */
    @Test
    public void transactionStuff() throws SystemException, NotSupportedException, HeuristicRollbackException,
            HeuristicMixedException, RollbackException, NamingException {
        TransactionalBeanIface bean = ctxDirectory.lookupStateful(MODULE_NAME, TransactionalBean.class,
                TransactionalBeanIface.class);
        UserTransaction lol = EJBClient.getUserTransaction(EAP6_NODE_NAME);
        lol.begin();
        bean.mandatory();
        lol.commit();
    }

}
