/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.qa.ejb.jndi;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.jboss.qa.tools.arquillian.extension.EAP6UserAuthConfiguration;

/**
 * @author ochaloup
 */
public class InitialContextDirectoryEAP6Remote extends InitialContextDirectory {
    private static final Logger log = Logger.getLogger(InitialContextDirectoryEAP6Remote.class);
    
    public InitialContextDirectoryEAP6Remote(String hostname, String port) {
        log.info("Using: " + this.getClass().getName() + " on host: " + hostname + ", port: " + port);
        try {
            ctx = createInitialContext(hostname, port);
        } catch (NamingException ne) {
            throw new RuntimeException(ne);
        }
    }
    
    public InitialContextDirectoryEAP6Remote(String hostname) {
        this(hostname, "4447");
    }
    
    public InitialContextDirectoryEAP6Remote() {
        this("localhost");
    }
    
    private InitialContext createInitialContext(String hostname, String port) throws NamingException {
        System.setProperty(CLASSLOADER_SCAN_PROPERTY_NAME, "true");
        Properties env = new Properties();
        env.put(Context.INITIAL_CONTEXT_FACTORY, "org.jboss.naming.remote.client.InitialContextFactory");
        env.put(Context.URL_PKG_PREFIXES, "org.jboss.ejb.client.naming");
        env.put(Context.PROVIDER_URL, "remote://" + hostname + ":" + port);
        env.put("jboss.naming.client.ejb.context", true);
        env.put("jboss.naming.client.connect.options.org.xnio.Options.SASL_POLICY_NOPLAINTEXT", false);
        // supposing that the AddAuthenticationRoleExtension added user
        if(EAP6UserAuthConfiguration.HASHED_PASSWORD != null) {
            env.put(Context.SECURITY_PRINCIPAL, EAP6UserAuthConfiguration.USER_NAME);
            env.put(Context.SECURITY_CREDENTIALS, EAP6UserAuthConfiguration.PASSWORD);
            env.put("jboss.naming.client.connect.options.org.xnio.Options.SASL_DISALLOWED_MECHANISMS", "JBOSS-LOCAL-USER");
        }
        return new InitialContext(env);
    }

    // distinctNames are NOT SUPPORTED for remote:// protocol
    public <T> String createJndiName(String earName, String jarName, Class<?> beanClass, Class<T> beanInterface) {
        earName = (earName == null || earName.trim().isEmpty()) ? "" : earName + "/";
        return String.format("%s%s/%s!%s", earName, jarName, beanClass.getSimpleName(), beanInterface.getName());
    }

    @Override
    public <T> T lookup(String earName, String jarName, Class<?> beanClass, Class<T> beanInterface, BeanType beanType, String distinctName)
            throws NamingException {
        String name = createJndiName(earName, jarName, beanClass, beanInterface);
        return getBean(name, beanInterface);
    }

}
